/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.http.ChunkedDataProvider;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.net.SocketException;

public abstract class ChunkingResponder
implements Responder,
ChunkedDataProvider {
    protected WikiPage root;
    public WikiPage page;
    protected WikiPagePath path;
    protected Request request;
    protected ChunkedResponse response;
    protected FitNesseContext context;
    private boolean dontChunk = false;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.request = request;
        this.root = context.root;
        String format = (String)request.getInput("format");
        this.response = new ChunkedResponse(format, (ChunkedDataProvider)this);
        if (this.dontChunk || request.hasInput("nochunk")) {
            this.response.turnOffChunking();
        }
        this.getRequestedPage(request);
        if (this.page == null && this.shouldRespondWith404()) {
            return this.pageNotFoundResponse(context, request);
        }
        return this.response;
    }

    public void turnOffChunking() {
        this.dontChunk = true;
    }

    private void getRequestedPage(Request request) {
        this.path = PathParser.parse((String)request.getResource());
        this.page = this.getPageCrawler().getPage(this.root, this.path);
    }

    protected PageCrawler getPageCrawler() {
        return this.root.getPageCrawler();
    }

    private Response pageNotFoundResponse(FitNesseContext context, Request request) {
        return new NotFoundResponder().makeResponse(context, request);
    }

    protected boolean shouldRespondWith404() {
        return true;
    }

    public void startSending() {
        try {
            this.doSending();
        }
        catch (SocketException e) {
            System.out.println("Socket Exception at: " + System.currentTimeMillis());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.addExceptionAndCloseResponse(e);
        }
    }

    private void addExceptionAndCloseResponse(Exception e) {
        try {
            this.response.add(ErrorResponder.makeExceptionString((Throwable)e));
            this.response.closeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getRenderedPath() {
        if (this.path != null) {
            return PathParser.render((WikiPagePath)this.path);
        }
        return this.request.getResource();
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    protected abstract void doSending() throws Exception;
}

