/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.http.ChunkedResponse;
import fitnesse.http.MockRequest;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.responders.ChunkingResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class ChunkingResponderTest {
    private Exception exception;
    private ChunkedResponse response;
    private FitNesseContext context;
    private WikiPage root = new WikiPageDummy();
    private ChunkingResponder responder = new /* Unavailable Anonymous Inner Class!! */;

    @Before
    public void setUp() throws Exception {
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    @Test
    public void testException() throws Exception {
        this.exception = new Exception("test exception");
        this.response = (ChunkedResponse)this.responder.makeResponse(this.context, (Request)new MockRequest());
        MockResponseSender sender = new MockResponseSender();
        sender.doSending((Response)this.response);
        String responseSender = sender.sentData();
        RegexTestCase.assertSubString((String)"test exception", (String)responseSender);
    }

    @Test
    public void chunkingShouldBeTurnedOffIfnochunkParameterIsPresent() throws Exception {
        MockRequest request = new MockRequest();
        request.addInput("nochunk", null);
        this.response = (ChunkedResponse)this.responder.makeResponse(this.context, (Request)request);
        RegexTestCase.assertTrue((boolean)this.response.isChunkingTurnedOff());
    }

    static /* synthetic */ Exception access$000(ChunkingResponderTest x0) {
        return x0.exception;
    }
}

