/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.Responder;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ResponderTestCase;
import fitnesse.responders.RssResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.Clock;
import util.XmlUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RssResponderTest
extends ResponderTestCase {
    protected Element channelElement;
    protected Element rssElement;
    protected Document rssDoc;
    private String date;
    private String rfcDate;
    private String hostName;

    protected Responder responderInstance() {
        return new RssResponder();
    }

    public void setUp() throws Exception {
        super.setUp();
        Locale.setDefault(Locale.US);
        SimpleDateFormat dateFormat = new SimpleDateFormat("kk:mm:ss EEE, MMM dd, yyyy");
        this.date = dateFormat.format(Clock.currentDate());
        SimpleDateFormat rfcDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        this.rfcDate = rfcDateFormat.format(Clock.currentDate());
        this.hostName = InetAddress.getLocalHost().getHostName();
    }

    public void testEmptyRssReport() throws Exception {
        this.buildRssChannel();
        RssResponderTest.assertEquals((String)"rss", (String)this.rssElement.getTagName());
        RssResponderTest.assertEquals((String)"2.0", (String)this.rssElement.getAttribute("version"));
        RssResponderTest.assertNotNull((Object)this.channelElement);
        RssResponderTest.assertEquals((String)"FitNesse:", (String)XmlUtil.getTextValue((Element)this.channelElement, (String)"title"));
    }

    public void testOneNewPage() throws Exception {
        NodeList items = this.getReportedItems("|MyNewPage|me|" + this.date + "|");
        RssResponderTest.assertEquals((int)1, (int)items.getLength());
        String title = "MyNewPage";
        String author = "me";
        String pubDate = this.rfcDate;
        String description = "me:" + this.rfcDate;
        this.checkItem(items.item(0), title, author, pubDate, description, "http://" + this.hostName + "/MyNewPage");
    }

    public void testTwoNewPages() throws Exception {
        String recentChangeOne = "|MyNewPage|me|" + this.date + "|";
        String recentChangeTwo = "|SomeOtherPage||" + this.date + "|";
        String recentChangesContent = recentChangeOne + "\n" + recentChangeTwo + "\n";
        NodeList items = this.getReportedItems(recentChangesContent);
        RssResponderTest.assertEquals((int)2, (int)items.getLength());
        this.checkItem(items.item(0), "MyNewPage", "me", this.rfcDate, "me:" + this.rfcDate, "http://" + this.hostName + "/MyNewPage");
        this.checkItem(items.item(1), "SomeOtherPage", null, this.rfcDate, this.rfcDate, "http://" + this.hostName + "/SomeOtherPage");
    }

    public void testReportedPagesSelectedByResource() throws Exception {
        this.request.setResource("FrontPage");
        String page1 = "|SomePage|me|" + this.date + "|";
        String page2 = "|FrontPage|me|" + this.date + "|";
        String page3 = "|FrontPage.MyPage|me|" + this.date + "|";
        String page4 = "|SomePage.FrontPage|me|" + this.date;
        String recentChangesContent = page1 + "\n" + page2 + "\n" + page3 + "\n" + page4 + "\n";
        NodeList items = this.getReportedItems(recentChangesContent);
        RssResponderTest.assertEquals((int)2, (int)items.getLength());
        this.checkItem(items.item(0), "FrontPage", "me", this.rfcDate, "me:" + this.rfcDate, "http://" + this.hostName + "/FrontPage");
        this.checkItem(items.item(1), "FrontPage.MyPage", "me", this.rfcDate, "me:" + this.rfcDate, "http://" + this.hostName + "/FrontPage.MyPage");
    }

    public void testLinkWithSetPrefix() throws Exception {
        PageData data = this.root.getData();
        data.setContent("!define RSS_PREFIX {http://host/}\n");
        this.root.commit(data);
        NodeList items = this.getReportedItems("|PageName|author|" + this.date + "|");
        RssResponderTest.assertEquals((int)1, (int)items.getLength());
        this.checkItem(items.item(0), "PageName", "author", this.rfcDate, "author:" + this.rfcDate, "http://host/PageName");
    }

    public void testLinkWitDefaultPrefix() throws Exception {
        NodeList items = this.getReportedItems("|PageName|author|" + this.date + "|");
        RssResponderTest.assertEquals((int)1, (int)items.getLength());
        this.checkItem(items.item(0), "PageName", "author", this.rfcDate, "author:" + this.rfcDate, "http://" + this.hostName + "/PageName");
    }

    public void testConvertDateFormat() throws Exception {
        SimpleDateFormat oldFormat = new SimpleDateFormat("kk:mm:ss EEE, MMM dd, yyyy");
        SimpleDateFormat newFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        String inDate = oldFormat.format(Clock.currentDate());
        String outDate = newFormat.format(Clock.currentDate());
        String convertedDate = RssResponder.RecentChangesPageEntry.convertDateFormat((String)inDate);
        RssResponderTest.assertEquals((String)convertedDate, (String)outDate);
    }

    public void testBadDateFormat() throws Exception {
        SimpleDateFormat oldFormat = new SimpleDateFormat("h:mm:ss a EEE MMM dd, yyyy");
        String inDate = oldFormat.format(Clock.currentDate());
        String convertedDate = RssResponder.RecentChangesPageEntry.convertDateFormat((String)inDate);
        RssResponderTest.assertEquals((String)convertedDate, (String)inDate);
    }

    private void buildRssChannel() throws Exception {
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(this.context, (Request)this.request);
        this.rssDoc = XmlUtil.newDocument((String)response.getContent());
        this.rssElement = this.rssDoc.getDocumentElement();
        this.channelElement = XmlUtil.getElementByTagName((Element)this.rssElement, (String)"channel");
    }

    private void checkItem(Node node, String title, String author, String pubDate, String description, String link) throws Exception {
        Element itemElement = (Element)node;
        RssResponderTest.assertEquals((String)title, (String)XmlUtil.getTextValue((Element)itemElement, (String)"title"));
        RssResponderTest.assertEquals((String)author, (String)XmlUtil.getTextValue((Element)itemElement, (String)"author"));
        RssResponderTest.assertEquals((String)pubDate, (String)XmlUtil.getTextValue((Element)itemElement, (String)"pubDate"));
        RssResponderTest.assertEquals((String)description, (String)XmlUtil.getTextValue((Element)itemElement, (String)"description"));
        RssResponderTest.assertEquals((String)link, (String)XmlUtil.getTextValue((Element)itemElement, (String)"link"));
    }

    private NodeList getReportedItems(String recentChangesContent) throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"RecentChanges"), recentChangesContent);
        this.buildRssChannel();
        return this.channelElement.getElementsByTagName("item");
    }
}

