/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.responders.templateUtilities.PageTitle;
import java.io.File;

public class DeleteConfirmationResponder
implements SecureResponder {
    private String resource;

    public Response makeResponse(FitNesseContext context, Request request) {
        SimpleResponse response = new SimpleResponse();
        this.resource = request.getResource();
        String filename = (String)request.getInput("filename");
        response.setContent(this.makeDirectoryListingPage(this.resource, filename, context));
        response.setLastModifiedHeader("Delete");
        return response;
    }

    private String makeDirectoryListingPage(String pageName, String filename, FitNesseContext context) {
        HtmlPage page = context.pageFactory.newPage();
        page.setTitle("Delete File(s)");
        page.setPageTitle(new PageTitle("Delete File", this.resource + filename, "/"));
        page.put("pageName", (Object)("/" + pageName));
        this.makeConfirmationHTML(page, filename, context);
        page.setMainTemplate("deleteConfirmation");
        return page.html();
    }

    private void makeConfirmationHTML(HtmlPage page, String filename, FitNesseContext context) {
        String pathname = context.getRootPagePath() + "/" + this.resource + filename;
        File file = new File(pathname);
        boolean isDir = file.isDirectory();
        page.put("filename", (Object)filename);
        page.put("isDir", (Object)isDir);
        if (isDir) {
            page.put("nFiles", (Object)file.listFiles().length);
        }
    }

    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

