/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.Responder;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ResponderTestCase;
import fitnesse.responders.refactoring.DeletePageResponder;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeletePageResponderTest
extends ResponderTestCase {
    private final String level1Name = "LevelOne";
    private final WikiPagePath level1Path;
    private final String level2Name = "LevelTwo";
    private final WikiPagePath level2Path;
    private final WikiPagePath level2FullPath;
    private final String qualifiedLevel2Name;

    public DeletePageResponderTest() {
        this.getClass();
        this.level1Path = PathParser.parse((String)"LevelOne");
        this.level2Name = "LevelTwo";
        this.getClass();
        this.level2Path = PathParser.parse((String)"LevelTwo");
        WikiPagePath wikiPagePath = this.level1Path.copy();
        this.getClass();
        this.level2FullPath = wikiPagePath.addNameToEnd("LevelTwo");
        this.qualifiedLevel2Name = PathParser.render((WikiPagePath)this.level2FullPath);
    }

    public void testDeleteConfirmation() throws Exception {
        WikiPage level1 = this.crawler.addPage(this.root, this.level1Path);
        this.crawler.addPage(level1, this.level2Path);
        MockRequest request = new MockRequest();
        request.setResource(this.qualifiedLevel2Name);
        request.addInput("deletePage", (Object)"");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)request);
        String content = response.getContent();
        DeletePageResponderTest.assertSubString((String)("Are you sure you want to delete " + this.qualifiedLevel2Name), (String)content);
    }

    public void testDeletePage() throws Exception {
        WikiPage level1 = this.crawler.addPage(this.root, this.level1Path);
        this.crawler.addPage(level1, this.level2Path);
        DeletePageResponderTest.assertTrue((boolean)this.crawler.pageExists(this.root, this.level1Path));
        MockRequest request = new MockRequest();
        this.getClass();
        request.setResource("LevelOne");
        request.addInput("confirmed", (Object)"yes");
        SimpleResponse response = (SimpleResponse)this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)request);
        String page = response.getContent();
        DeletePageResponderTest.assertNotSubString((String)"Are you sure you want to delete", (String)page);
        DeletePageResponderTest.assertEquals((int)303, (int)response.getStatus());
        DeletePageResponderTest.assertEquals((String)"root", (String)response.getHeader("Location"));
        this.getClass();
        DeletePageResponderTest.assertFalse((boolean)this.crawler.pageExists(this.root, PathParser.parse((String)"LevelOne")));
        List children = this.root.getChildren();
        DeletePageResponderTest.assertEquals((int)0, (int)children.size());
    }

    public void testDontDeleteFrontPage() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"FrontPage"), "Content");
        this.request.setResource("FrontPage");
        this.request.addInput("confirmed", (Object)"yes");
        Response response = this.responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)this.request);
        DeletePageResponderTest.assertEquals((int)303, (int)response.getStatus());
        DeletePageResponderTest.assertEquals((String)"FrontPage", (String)response.getHeader("Location"));
    }

    protected Responder responderInstance() {
        return new DeletePageResponder();
    }
}

