/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.responders.run.ExecutionReport;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.StringWriter;
import java.io.Writer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import util.DateTimeUtil;
import util.TimeMeasurement;

public class ExecutionReportTest {
    private WikiPage root;
    private FitNesseContext context;

    @Before
    public void setup() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
    }

    @Test
    public void canReadTestExecutionReport() throws Exception {
        TestExecutionReport original = new TestExecutionReport();
        original.version = "version";
        original.rootPath = "rootPath";
        original.setTotalRunTimeInMillis(this.totalTimeMeasurementWithElapsedMillis(42L));
        StringWriter writer = new StringWriter();
        original.toXml((Writer)writer, this.context.pageFactory.getVelocityEngine());
        ExecutionReport report = ExecutionReport.makeReport((String)writer.toString());
        Assert.assertTrue((boolean)(report instanceof TestExecutionReport));
        Assert.assertEquals((Object)original, (Object)report);
        Assert.assertEquals((long)42L, (long)report.getTotalRunTimeInMillis());
    }

    private TimeMeasurement totalTimeMeasurementWithElapsedMillis(long millis) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void canMakeSuiteExecutionReport() throws Exception {
        SuiteExecutionReport original = new SuiteExecutionReport();
        original.version = "version";
        original.rootPath = "rootPath";
        original.date = DateTimeUtil.getDateFromString((String)"12/31/1969 18:00:00");
        original.finalCounts = new TestSummary(1, 2, 3, 4);
        original.setTotalRunTimeInMillis(this.totalTimeMeasurementWithElapsedMillis(41L));
        long time = DateTimeUtil.getTimeFromString((String)"12/31/1969 18:00:00");
        SuiteExecutionReport.PageHistoryReference reference = new SuiteExecutionReport.PageHistoryReference("dah", time, 3L);
        reference.getTestSummary().wrong = 99;
        original.addPageHistoryReference(reference);
        StringWriter writer = new StringWriter();
        original.toXml((Writer)writer, this.context.pageFactory.getVelocityEngine());
        ExecutionReport report = ExecutionReport.makeReport((String)writer.toString());
        Assert.assertTrue((boolean)(report instanceof SuiteExecutionReport));
        Assert.assertEquals((Object)original, (Object)report);
        Assert.assertEquals((long)41L, (long)report.getTotalRunTimeInMillis());
    }

    @Test
    public void shouldHandleMissingRunTimesGraceFully() throws Exception {
        TestExecutionReport report = new TestExecutionReport();
        Element element = (Element)Mockito.mock(Element.class);
        NodeList emptyNodeList = (NodeList)Mockito.mock(NodeList.class);
        Mockito.when((Object)element.getElementsByTagName("totalRunTimeInMillis")).thenReturn((Object)emptyNodeList);
        Mockito.when((Object)emptyNodeList.getLength()).thenReturn((Object)0);
        Assert.assertThat((Object)report.getTotalRunTimeInMillisOrZeroIfNotPresent(element), (Matcher)CoreMatchers.is((Object)0L));
        element = (Element)Mockito.mock(Element.class);
        NodeList matchingNodeList = (NodeList)Mockito.mock(NodeList.class);
        Node elementWithText = (Node)Mockito.mock(Element.class);
        NodeList childNodeList = (NodeList)Mockito.mock(NodeList.class);
        Text text = (Text)Mockito.mock(Text.class);
        Mockito.when((Object)element.getElementsByTagName("totalRunTimeInMillis")).thenReturn((Object)matchingNodeList);
        Mockito.when((Object)matchingNodeList.getLength()).thenReturn((Object)1);
        Mockito.when((Object)matchingNodeList.item(0)).thenReturn((Object)elementWithText);
        Mockito.when((Object)elementWithText.getChildNodes()).thenReturn((Object)childNodeList);
        Mockito.when((Object)childNodeList.getLength()).thenReturn((Object)1);
        Mockito.when((Object)childNodeList.item(0)).thenReturn((Object)text);
        Mockito.when((Object)text.getNodeValue()).thenReturn((Object)"255");
        Assert.assertThat((Object)report.getTotalRunTimeInMillisOrZeroIfNotPresent(element), (Matcher)CoreMatchers.is((Object)255L));
    }

    @Test
    public void hasRunTimesShouldBeVersionAware() throws Exception {
        Assert.assertFalse((boolean)this.executionReportWithVersion("v20100303").hasRunTimes());
        Assert.assertTrue((boolean)this.executionReportWithVersion("v20100607").hasRunTimes());
        Assert.assertTrue((boolean)this.executionReportWithVersion("v20100608").hasRunTimes());
    }

    private ExecutionReport executionReportWithVersion(String theVersion) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

