/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fit.FitProtocol;
import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.components.ClassPathBuilder;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.responders.run.PuppetResponse;
import fitnesse.responders.run.ResponsePuppeteer;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.SuiteFilter;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestPageWithSuiteSetUpAndTearDown;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.fit.FitClient;
import fitnesse.testsystems.slim.results.ExceptionResult;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;

public class FitClientResponder
implements Responder,
ResponsePuppeteer,
TestSystemListener {
    private FitNesseContext context;
    private PageCrawler crawler;
    private String resource;
    private WikiPage page;
    private boolean shouldIncludePaths;
    private String suiteFilter;

    public Response makeResponse(FitNesseContext context, Request request) {
        this.context = context;
        this.crawler = context.root.getPageCrawler();
        this.resource = request.getResource();
        this.shouldIncludePaths = request.hasInput("includePaths");
        this.suiteFilter = (String)request.getInput("suiteFilter");
        return new PuppetResponse((ResponsePuppeteer)this);
    }

    public void readyToSend(ResponseSender sender) {
        Socket socket = sender.getSocket();
        WikiPagePath pagePath = PathParser.parse((String)this.resource);
        try {
            if (!this.crawler.pageExists(this.context.root, pagePath)) {
                FitProtocol.writeData((String)this.notFoundMessage(), (OutputStream)socket.getOutputStream());
            } else {
                this.page = this.crawler.getPage(this.context.root, pagePath);
                PageData data = this.page.getData();
                if (data.hasAttribute("Suite")) {
                    this.handleSuitePage(socket, this.page, this.context.root);
                } else if (data.hasAttribute("Test")) {
                    this.handleTestPage(socket, this.page);
                } else {
                    FitProtocol.writeData((String)this.notATestMessage(), (OutputStream)socket.getOutputStream());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        sender.close();
    }

    private void handleTestPage(Socket socket, WikiPage testPage) throws IOException, InterruptedException {
        FitClient client = this.startClient(socket);
        if (this.shouldIncludePaths) {
            String classpath = new ClassPathBuilder().getClasspath(this.page);
            client.send(classpath);
        }
        this.sendPage((TestPage)new TestPageWithSuiteSetUpAndTearDown(testPage), client);
        this.closeClient(client);
    }

    private void handleSuitePage(Socket socket, WikiPage page, WikiPage root) throws IOException, InterruptedException {
        FitClient client = this.startClient(socket);
        SuiteFilter filter = new SuiteFilter(this.suiteFilter, null, null, null);
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(page, filter, root);
        List testPages = suiteTestFinder.makePageList();
        if (this.shouldIncludePaths) {
            String classpath = new ClassPathBuilder().buildClassPath(testPages);
            client.send(classpath);
        }
        for (WikiPage testPage : testPages) {
            this.sendPage(new TestPage(testPage), client);
        }
        this.closeClient(client);
    }

    private void sendPage(TestPage testPage, FitClient client) throws IOException, InterruptedException {
        String pageName = this.crawler.getRelativeName(this.page, testPage.getSourcePage());
        String testableHtml = testPage.getDecoratedData().getHtml();
        String sendableHtml = pageName + "\n" + testableHtml;
        client.send(sendableHtml);
    }

    private void closeClient(FitClient client) throws IOException, InterruptedException {
        client.done();
        client.join();
    }

    private FitClient startClient(Socket socket) throws IOException, InterruptedException {
        FitClient client = new FitClient((TestSystemListener)this);
        client.acceptSocket(socket);
        return client;
    }

    private String notATestMessage() {
        return this.resource + " is neither a Test page nor a Suite page.";
    }

    private String notFoundMessage() {
        return "The page " + this.resource + " was not found.";
    }

    public void testOutputChunk(String output) {
    }

    public void testComplete(TestSummary testSummary) {
    }

    public void exceptionOccurred(Throwable e) {
    }

    public void testAssertionVerified(Assertion assertion, TestResult testResult) {
    }

    public void testExceptionOccurred(Assertion assertion, ExceptionResult exceptionResult) {
    }
}

