/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.FitNesseContext;
import fitnesse.components.ClassPathBuilder;
import fitnesse.responders.PageFactory;
import fitnesse.responders.run.MultipleTestsRunner;
import fitnesse.responders.run.PagesByTestSystem;
import fitnesse.responders.run.ResultsListener;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystem;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import util.RegexTestCase;
import util.TimeMeasurement;

public class MultipleTestsRunnerTest {
    private WikiPage root;
    private WikiPage suite;
    private WikiPage testPage;
    private PageCrawler crawler;
    private String suitePageName;
    private final String simpleSlimDecisionTable = "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n";
    private List<WikiPage> testPages;
    private FitNesseContext context;

    @Before
    public void setUp() throws Exception {
        this.suitePageName = "SuitePage";
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.crawler = this.root.getPageCrawler();
        PageData data = this.root.getData();
        data.setContent(this.classpathWidgets());
        this.root.commit(data);
        this.suite = this.crawler.addPage(this.root, PathParser.parse((String)this.suitePageName), "This is the test suite\n");
        this.testPages = new LinkedList();
        this.testPage = this.addTestPage(this.suite, "TestOne", "My test");
    }

    @Test
    public void testBuildClassPath() throws Exception {
        String classpath = new ClassPathBuilder().buildClassPath(this.testPages);
        RegexTestCase.assertSubString((String)"classes", (String)classpath);
        RegexTestCase.assertSubString((String)"dummy.jar", (String)classpath);
    }

    @Test
    public void testGenerateSuiteMapWithMultipleTestSystems() throws Exception {
        WikiPage slimPage = this.addTestPage(this.suite, "SlimTest", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        MultipleTestsRunner runner = new MultipleTestsRunner(this.testPages, this.context, this.suite, null);
        PagesByTestSystem map = runner.makeMapOfPagesByTestSystem();
        TestSystem.Descriptor fitDescriptor = TestSystem.getDescriptor((WikiPage)this.testPage, (PageFactory)this.context.pageFactory, (boolean)false);
        TestSystem.Descriptor slimDescriptor = TestSystem.getDescriptor((WikiPage)slimPage, (PageFactory)this.context.pageFactory, (boolean)false);
        List fitList = (List)map.get(fitDescriptor);
        List slimList = (List)map.get(slimDescriptor);
        Assert.assertEquals((long)1L, (long)fitList.size());
        Assert.assertEquals((long)1L, (long)slimList.size());
        Assert.assertEquals((Object)this.testPage, (Object)((TestPage)fitList.get(0)).getSourcePage());
        Assert.assertEquals((Object)slimPage, (Object)((TestPage)slimList.get(0)).getSourcePage());
    }

    @Test
    public void testPagesForTestSystemAreSurroundedBySuiteSetupAndTeardown() throws Exception {
        WikiPage slimPage = this.addTestPage(this.suite, "AaSlimTest", "!define TEST_SYSTEM {slim}\n|!-DT:fitnesse.slim.test.TestSlim-!|\n|string|get string arg?|\n|wow|wow|\n");
        WikiPage setUp = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"), "suite set up");
        WikiPage tearDown = this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"), "suite tear down");
        this.testPages = new LinkedList();
        this.testPages.add(setUp);
        this.testPages.add(slimPage);
        this.testPages.add(this.testPage);
        this.testPages.add(tearDown);
        MultipleTestsRunner runner = new MultipleTestsRunner(this.testPages, this.context, this.suite, null);
        PagesByTestSystem map = runner.makeMapOfPagesByTestSystem();
        TestSystem.Descriptor fitDescriptor = TestSystem.getDescriptor((WikiPage)this.testPage, (PageFactory)this.context.pageFactory, (boolean)false);
        TestSystem.Descriptor slimDescriptor = TestSystem.getDescriptor((WikiPage)slimPage, (PageFactory)this.context.pageFactory, (boolean)false);
        List fitList = (List)map.get(fitDescriptor);
        List slimList = (List)map.get(slimDescriptor);
        Assert.assertEquals((long)3L, (long)fitList.size());
        Assert.assertEquals((long)3L, (long)slimList.size());
        Assert.assertEquals((Object)setUp, (Object)((TestPage)fitList.get(0)).getSourcePage());
        Assert.assertEquals((Object)this.testPage, (Object)((TestPage)fitList.get(1)).getSourcePage());
        Assert.assertEquals((Object)tearDown, (Object)((TestPage)fitList.get(2)).getSourcePage());
        Assert.assertEquals((Object)setUp, (Object)((TestPage)slimList.get(0)).getSourcePage());
        Assert.assertEquals((Object)slimPage, (Object)((TestPage)slimList.get(1)).getSourcePage());
        Assert.assertEquals((Object)tearDown, (Object)((TestPage)slimList.get(2)).getSourcePage());
    }

    private WikiPage addTestPage(WikiPage page, String name, String content) throws Exception {
        WikiPage testPage = this.crawler.addPage(page, PathParser.parse((String)name), content);
        PageData data = testPage.getData();
        data.setAttribute("Test");
        testPage.commit(data);
        this.testPages.add(testPage);
        return testPage;
    }

    private String classpathWidgets() {
        return "!path classes\n!path lib/dummy.jar\n";
    }

    @Test
    public void startingNewTestShouldStartTimeMeasurementAndNotifyListener() throws Exception {
        List testPagesToRun = (List)Mockito.mock(List.class);
        TestPage page = new TestPage((WikiPage)Mockito.mock(WikiPage.class));
        FitNesseContext fitNesseContext = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        ResultsListener resultsListener = (ResultsListener)Mockito.mock(ResultsListener.class);
        MultipleTestsRunner runner = new MultipleTestsRunner(testPagesToRun, fitNesseContext, page.getSourcePage(), resultsListener);
        runner.startingNewTest(page);
        ((ResultsListener)Mockito.verify((Object)resultsListener)).newTestStarted((TestPage)Mockito.same((Object)page), (TimeMeasurement)Mockito.same((Object)runner.currentTestTime));
        Assert.assertThat((Object)runner.currentTestTime, (Matcher)this.isAStartedTimeMeasurement());
    }

    private ArgumentMatcher<TimeMeasurement> isAStartedTimeMeasurement() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void testCompleteShouldRemoveHeadOfQueueAndNotifyListener() throws Exception {
        List testPagesToRun = (List)Mockito.mock(List.class);
        TestPage page = new TestPage((WikiPage)Mockito.mock(WikiPage.class));
        FitNesseContext fitNesseContext = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        ResultsListener resultsListener = (ResultsListener)Mockito.mock(ResultsListener.class);
        MultipleTestsRunner runner = new MultipleTestsRunner(testPagesToRun, fitNesseContext, page.getSourcePage(), resultsListener);
        runner.addToProcessingQueue(page);
        TestSummary testSummary = (TestSummary)Mockito.mock(TestSummary.class);
        runner.startingNewTest(page);
        runner.testComplete(testSummary);
        ((ResultsListener)Mockito.verify((Object)resultsListener)).testComplete((TestPage)Mockito.same((Object)page), (TestSummary)Mockito.same((Object)testSummary), (TimeMeasurement)Mockito.same((Object)runner.currentTestTime));
        Assert.assertThat((Object)runner.currentTestTime, (Matcher)this.isAStoppedTimeMeasurement());
    }

    private ArgumentMatcher<TimeMeasurement> isAStoppedTimeMeasurement() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void announceTotalTestsToRunShouldStartTotalTimeMeasurement() throws Exception {
        List testPagesToRun = (List)Mockito.mock(List.class);
        WikiPage page = (WikiPage)Mockito.mock(WikiPage.class);
        FitNesseContext fitNesseContext = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        ResultsListener resultsListener = (ResultsListener)Mockito.mock(ResultsListener.class);
        MultipleTestsRunner runner = new MultipleTestsRunner(testPagesToRun, fitNesseContext, page, resultsListener);
        runner.announceTotalTestsToRun(new PagesByTestSystem());
        ((ResultsListener)Mockito.verify((Object)resultsListener)).announceNumberTestsToRun(0);
        Assert.assertThat((Object)runner.totalTestTime, (Matcher)this.isAStartedTimeMeasurement());
    }

    @Test
    public void allTestingCompleteShouldStopTotalTimeMeasurement() throws Exception {
        List testPagesToRun = (List)Mockito.mock(List.class);
        WikiPage page = (WikiPage)Mockito.mock(WikiPage.class);
        FitNesseContext fitNesseContext = (FitNesseContext)Mockito.mock(FitNesseContext.class);
        ResultsListener resultsListener = (ResultsListener)Mockito.mock(ResultsListener.class);
        MultipleTestsRunner runner = new MultipleTestsRunner(testPagesToRun, fitNesseContext, page, resultsListener);
        runner.announceTotalTestsToRun(new PagesByTestSystem());
        runner.allTestingComplete();
        ((ResultsListener)Mockito.verify((Object)resultsListener)).allTestingComplete((TimeMeasurement)Mockito.same((Object)runner.totalTestTime));
        Assert.assertThat((Object)runner.totalTestTime, (Matcher)this.isAStoppedTimeMeasurement());
    }
}

