/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.SuiteFilter;
import fitnesse.responders.run.SuiteSpecificationRunner;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageDummy;
import fitnesse.wiki.WikiPagePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class SuiteContentsFinder {
    private final WikiPage pageToRun;
    private final WikiPage wikiRootPage;
    private final SuiteFilter suiteFilter;
    private LinkedList<WikiPage> testPageList;

    public SuiteContentsFinder(WikiPage pageToRun, SuiteFilter suiteFilter, WikiPage root) {
        this.pageToRun = pageToRun;
        this.wikiRootPage = root;
        this.suiteFilter = suiteFilter != null ? suiteFilter : SuiteFilter.MATCH_ALL;
        this.testPageList = new LinkedList();
    }

    public List<WikiPage> makePageListForSingleTest() {
        this.testPageList = new LinkedList();
        this.testPageList.add(this.pageToRun);
        return this.testPageList;
    }

    public List<WikiPage> makePageList() {
        this.getAllPagesToRunForThisSuite();
        if (this.testPageList.isEmpty()) {
            String name = new WikiPagePath(this.pageToRun).toString();
            WikiPageDummy dummy = new WikiPageDummy("", "|Comment|\n|No test found with " + this.suiteFilter.toString() + " in subwiki !-" + name + "-!!|\n");
            dummy.setParent(this.wikiRootPage);
            this.testPageList.add(dummy);
        }
        return this.testPageList;
    }

    public LinkedList<WikiPage> getAllPagesToRunForThisSuite() {
        String content = this.pageToRun.getData().getHtml();
        if (SuiteSpecificationRunner.isASuiteSpecificationsPage((String)content)) {
            SuiteSpecificationRunner runner = new SuiteSpecificationRunner(this.wikiRootPage);
            if (runner.getPageListFromPageContent(content)) {
                this.testPageList = runner.testPageList;
            }
        } else {
            this.testPageList = this.getAllTestPagesUnder();
            List referencedPages = this.gatherCrossReferencedTestPages();
            this.testPageList.addAll(referencedPages);
        }
        return this.testPageList;
    }

    private LinkedList<WikiPage> getAllTestPagesUnder() {
        LinkedList<WikiPage> testPages = new LinkedList<WikiPage>();
        this.addTestPagesToSuite(testPages, this.pageToRun, this.suiteFilter);
        Collections.sort(testPages, new /* Unavailable Anonymous Inner Class!! */);
        return testPages;
    }

    private void addTestPagesToSuite(List<WikiPage> suite, WikiPage page, SuiteFilter suiteFilter) {
        if (suiteFilter.isMatchingTest(page)) {
            suite.add(page);
        }
        SuiteFilter suiteFilterForChildren = suiteFilter.getFilterForTestsInSuite(page);
        List children = SuiteContentsFinder.getChildren((WikiPage)page);
        for (WikiPage child : children) {
            this.addTestPagesToSuite(suite, child, suiteFilterForChildren);
        }
    }

    private static List<WikiPage> getChildren(WikiPage page) {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        children.addAll(page.getChildren());
        return children;
    }

    protected List<WikiPage> gatherCrossReferencedTestPages() {
        LinkedList<WikiPage> pages = new LinkedList<WikiPage>();
        this.addAllXRefs(pages, this.pageToRun);
        return pages;
    }

    private void addAllXRefs(List<WikiPage> xrefPages, WikiPage page) {
        List children = page.getChildren();
        this.addXrefPages(xrefPages, page);
        for (WikiPage child : children) {
            this.addAllXRefs(xrefPages, child);
        }
    }

    private void addXrefPages(List<WikiPage> pages, WikiPage thePage) {
        ReadOnlyPageData data = thePage.readOnlyData();
        List pageReferences = data.getXrefPages();
        PageCrawler crawler = thePage.getPageCrawler();
        WikiPagePath testPagePath = crawler.getFullPath(thePage);
        WikiPage parent = crawler.getPage(this.wikiRootPage, testPagePath.parentPath());
        for (String pageReference : pageReferences) {
            WikiPagePath path = PathParser.parse((String)pageReference);
            WikiPage referencedPage = crawler.getPage(parent, path);
            if (referencedPage == null) continue;
            pages.add(referencedPage);
        }
    }

    public static boolean isSuiteSetupOrTearDown(WikiPage testPage) {
        String name = testPage.getName();
        return "SuiteSetUp".equals(name) || "SuiteTearDown".equals(name);
    }
}

