/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SuiteContentsFinderTest {
    private WikiPage root;
    private WikiPage suite;
    private WikiPage testPage;
    private PageCrawler crawler;
    private WikiPage testPage2;
    private WikiPage testChildPage;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.crawler = this.root.getPageCrawler();
        PageData data = this.root.getData();
        this.root.commit(data);
        this.suite = this.crawler.addPage(this.root, PathParser.parse((String)"SuitePageName"), "The is the test suite\n");
        this.testPage = this.addTestPage(this.suite, "TestOne", "My test and has some content");
    }

    private WikiPage addTestPage(WikiPage page, String name, String content) throws Exception {
        WikiPage testPage = this.crawler.addPage(page, PathParser.parse((String)name), content);
        PageData data = testPage.getData();
        data.setAttribute("Test");
        testPage.commit(data);
        return testPage;
    }

    @Test
    public void testGatherXRefTestPages() throws Exception {
        WikiPage testPage = this.crawler.addPage(this.root, PathParser.parse((String)"SomePage"), "!see PageA\n!see PageB");
        WikiPage pageA = this.crawler.addPage(this.root, PathParser.parse((String)"PageA"));
        WikiPage pageB = this.crawler.addPage(this.root, PathParser.parse((String)"PageB"));
        SuiteContentsFinder finder = new SuiteContentsFinder(testPage, null, this.root);
        List xrefTestPages = finder.gatherCrossReferencedTestPages();
        Assert.assertEquals((long)2L, (long)xrefTestPages.size());
        Assert.assertTrue((boolean)xrefTestPages.contains(pageA));
        Assert.assertTrue((boolean)xrefTestPages.contains(pageB));
    }

    @Test
    public void shouldTestXRefsInSubSuites() throws Exception {
        this.crawler.addPage(this.suite, PathParser.parse((String)"SubSuite"), "!see .PageA\n!see .PageB");
        WikiPage pageA = this.crawler.addPage(this.root, PathParser.parse((String)"PageA"));
        WikiPage pageB = this.crawler.addPage(this.root, PathParser.parse((String)"PageB"));
        SuiteContentsFinder finder = new SuiteContentsFinder(this.suite, null, this.root);
        List xrefTestPages = finder.gatherCrossReferencedTestPages();
        Assert.assertEquals((long)2L, (long)xrefTestPages.size());
        Assert.assertTrue((boolean)xrefTestPages.contains(pageA));
        Assert.assertTrue((boolean)xrefTestPages.contains(pageB));
    }

    private void setUpForGetAllTestPages() throws Exception {
        this.testPage2 = this.addTestPage(this.suite, "TestPageTwo", "test page two");
        this.testChildPage = this.testPage2.addChildPage("ChildPage");
        PageData data = this.testChildPage.getData();
        data.setAttribute("Test");
        this.testChildPage.commit(data);
    }

    @Test
    public void testGetAllTestPages() throws Exception {
        this.setUpForGetAllTestPages();
        SuiteContentsFinder finder = new SuiteContentsFinder(this.suite, null, this.root);
        List testPages = finder.makePageList();
        Assert.assertEquals((long)3L, (long)testPages.size());
        Assert.assertEquals((Object)true, (Object)testPages.contains(this.testPage));
        Assert.assertEquals((Object)true, (Object)testPages.contains(this.testPage2));
        Assert.assertEquals((Object)true, (Object)testPages.contains(this.testChildPage));
    }

    @Test
    public void testGetAllTestPagesSortsByQulifiedNames() throws Exception {
        this.setUpForGetAllTestPages();
        SuiteContentsFinder finder = new SuiteContentsFinder(this.suite, null, this.root);
        List testPages = finder.makePageList();
        Assert.assertEquals((long)3L, (long)testPages.size());
        Assert.assertEquals((Object)this.testPage, testPages.get(0));
        Assert.assertEquals((Object)this.testPage2, testPages.get(1));
        Assert.assertEquals((Object)this.testChildPage, testPages.get(2));
    }

    @Test
    public void shouldTellIfItIsASpecificationsSuite() throws Exception {
        this.crawler.addPage(this.root, PathParser.parse((String)"SuiteSetUp"), "suite set up");
        this.crawler.addPage(this.root, PathParser.parse((String)"SuiteTearDown"), "suite tear down");
        this.setUpForGetAllTestPages();
        String content = "|Suite|\n|Title|Test|\n|Content|.|\n";
        this.suite.commit(new PageData(this.suite, content));
        SuiteContentsFinder finder = new SuiteContentsFinder(this.suite, null, this.root);
        LinkedList testPages = finder.getAllPagesToRunForThisSuite();
        Assert.assertEquals((long)2L, (long)testPages.size());
        Assert.assertSame((Object)this.testPage, testPages.get(1));
        Assert.assertSame((Object)this.testPage2, testPages.get(0));
    }
}

