/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.ExecutionReport;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.testsystems.ExecutionResult;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import util.DateTimeUtil;
import util.XmlUtil;

public class SuiteExecutionReport
extends ExecutionReport {
    private List<PageHistoryReference> pageHistoryReferences = new ArrayList();

    public SuiteExecutionReport(Document xmlDocument) throws Exception {
        super(xmlDocument);
        this.unpackXml();
    }

    public SuiteExecutionReport() {
    }

    public boolean equals(Object o) {
        if (o instanceof SuiteExecutionReport) {
            SuiteExecutionReport report = (SuiteExecutionReport)o;
            if (!super.equals((Object)report)) {
                return false;
            }
            if (this.pageHistoryReferences.size() != report.pageHistoryReferences.size()) {
                return false;
            }
            return this.allReferencesEqual(this.pageHistoryReferences, report.pageHistoryReferences);
        }
        return false;
    }

    private boolean allReferencesEqual(List<PageHistoryReference> r1, List<PageHistoryReference> r2) {
        for (int i = 0; i < r1.size(); ++i) {
            if (r1.get(i).equals((Object)r2.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("SuiteExecutionReport({%s}{%s})", super.toString(), this.pageHistoryReferencesToString());
    }

    private String pageHistoryReferencesToString() {
        StringBuilder builder = new StringBuilder();
        if (this.pageHistoryReferences.size() > 0) {
            for (PageHistoryReference reference : this.pageHistoryReferences) {
                builder.append(reference.toString());
                builder.append(",");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public void toXml(Writer writer, VelocityEngine velocityEngine) throws Exception {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("suiteExecutionReport", (Object)this);
        Template template = velocityEngine.getTemplate("suiteHistoryXML.vm");
        template.merge((Context)velocityContext, writer);
    }

    protected void unpackResults(Element testResults) {
        NodeList references = testResults.getElementsByTagName("pageHistoryReference");
        for (int referenceIndex = 0; referenceIndex < references.getLength(); ++referenceIndex) {
            Element refElement = (Element)references.item(referenceIndex);
            String name = XmlUtil.getTextValue((Element)refElement, (String)"name");
            long time = DateTimeUtil.getTimeFromString((String)XmlUtil.getTextValue((Element)refElement, (String)"date"));
            long runTimeInMillis = this.getRunTimeInMillisOrZeroIfNotPresent(refElement);
            PageHistoryReference r1 = new PageHistoryReference(name, time, runTimeInMillis);
            Element counts = XmlUtil.getElementByTagName((Element)refElement, (String)"counts");
            r1.getTestSummary().right = new Integer(XmlUtil.getTextValue((Element)counts, (String)"right"));
            r1.getTestSummary().wrong = new Integer(XmlUtil.getTextValue((Element)counts, (String)"wrong"));
            r1.getTestSummary().ignores = new Integer(XmlUtil.getTextValue((Element)counts, (String)"ignores"));
            r1.getTestSummary().exceptions = new Integer(XmlUtil.getTextValue((Element)counts, (String)"exceptions"));
            this.pageHistoryReferences.add(r1);
        }
    }

    protected long getRunTimeInMillisOrZeroIfNotPresent(Element refElement) {
        String textValue = XmlUtil.getTextValue((Element)refElement, (String)"runTimeInMillis");
        return textValue == null ? 0L : Long.parseLong(textValue);
    }

    public List<PageHistoryReference> getPageHistoryReferences() {
        return this.pageHistoryReferences;
    }

    public void addPageHistoryReference(PageHistoryReference reference) {
        this.pageHistoryReferences.add(reference);
    }

    public void tallyPageCounts(ExecutionResult result) {
        this.finalCounts.tallyPageCounts(result);
    }
}

