/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.http.Request;
import fitnesse.responders.run.SuiteFilter;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.LinkedList;
import util.StringUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SuiteFilter {
    private static final String NOT_FILTER_ARG = "excludeSuiteFilter";
    private static final String AND_FILTER_ARG = "runTestsMatchingAllTags";
    private static final String OR_FILTER_ARG_1 = "runTestsMatchingAnyTag";
    private static final String OR_FILTER_ARG_2 = "suiteFilter";
    private final SuiteTagMatcher notMatchTags;
    private final SuiteTagMatcher matchTags;
    private final boolean andStrategy;
    private final String startWithTest;
    public static final SuiteFilter NO_MATCHING = new /* Unavailable Anonymous Inner Class!! */;
    public static final SuiteFilter MATCH_ALL = new SuiteFilter(null, null, null, null);

    SuiteFilter(String orTags, String mustNotMatchTags, String andTags, String startWithTest) {
        String string = this.startWithTest = !"".equals(startWithTest) ? startWithTest : null;
        if (andTags != null) {
            this.matchTags = new SuiteTagMatcher(this, andTags, true);
            this.andStrategy = true;
        } else {
            this.matchTags = new SuiteTagMatcher(this, orTags, true);
            this.andStrategy = false;
        }
        this.notMatchTags = new SuiteTagMatcher(this, mustNotMatchTags, false);
    }

    public SuiteFilter(Request request, String suitePath) {
        this(SuiteFilter.getOrTagFilter((Request)request), SuiteFilter.getNotSuiteFilter((Request)request), SuiteFilter.getAndTagFilters((Request)request), SuiteFilter.getSuiteFirstTest((Request)request, (String)suitePath));
    }

    public SuiteFilter(String suiteFilter, String excludeSuiteFilter) {
        this.matchTags = new SuiteTagMatcher(this, suiteFilter, true);
        this.notMatchTags = new SuiteTagMatcher(this, excludeSuiteFilter, false);
        this.andStrategy = false;
        this.startWithTest = null;
    }

    private static String getOrTagFilter(Request request) {
        return request != null ? SuiteFilter.getOrFilterString((Request)request) : null;
    }

    private static String getOrFilterString(Request request) {
        String orFilterString = null;
        orFilterString = request.getInput("runTestsMatchingAnyTag") != null ? (String)request.getInput("runTestsMatchingAnyTag") : (String)request.getInput("suiteFilter");
        return orFilterString;
    }

    private static String getNotSuiteFilter(Request request) {
        return request != null ? (String)request.getInput("excludeSuiteFilter") : null;
    }

    private static String getAndTagFilters(Request request) {
        return request != null ? (String)request.getInput("runTestsMatchingAllTags") : null;
    }

    private static String getSuiteFirstTest(Request request, String suiteName) {
        String startTest = null;
        if (request != null) {
            startTest = (String)request.getInput("firstTest");
        }
        if (startTest != null && startTest.indexOf(suiteName) != 0) {
            startTest = suiteName + "." + startTest;
        }
        return startTest;
    }

    public boolean isMatchingTest(WikiPage testPage) {
        PageData data = testPage.getData();
        boolean pruned = data.hasAttribute("Prune");
        boolean isTest = data.hasAttribute("Test");
        return !pruned && isTest && this.matchTags.matches(testPage) && !this.notMatchTags.matches(testPage) && this.afterStartingTest(testPage);
    }

    private boolean afterStartingTest(WikiPage testPage) {
        if (this.startWithTest == null) {
            return true;
        }
        PageCrawler crawler = testPage.getPageCrawler();
        WikiPagePath pageName = crawler.getFullPath(testPage);
        return pageName.toString().compareTo(this.startWithTest) >= 0;
    }

    public boolean hasMatchingTests() {
        return this != NO_MATCHING;
    }

    public SuiteFilter getFilterForTestsInSuite(WikiPage suitePage) {
        if (suitePage.getData().hasAttribute("Prune")) {
            return NO_MATCHING;
        }
        PageData pageData = suitePage.getData();
        if (pageData.hasAttribute("Suite") && this.matchTags.isFiltering() && this.matchTags.matches(suitePage)) {
            return new SuiteFilter(null, this.notMatchTags.tagString, null, this.startWithTest).getFilterForTestsInSuite(suitePage);
        }
        if (this.notMatchTags.matches(suitePage)) {
            return NO_MATCHING;
        }
        return this;
    }

    public String toString() {
        LinkedList<String> criterias = new LinkedList<String>();
        if (this.matchTags.isFiltering()) {
            if (this.andStrategy) {
                criterias.add("matches all of '" + this.matchTags.tagString + "'");
            } else {
                criterias.add("matches '" + this.matchTags.tagString + "'");
            }
        }
        if (this.notMatchTags.isFiltering()) {
            criterias.add("doesn't match '" + this.notMatchTags.tagString + "'");
        }
        if (this.startWithTest != null) {
            criterias.add("starts with test '" + this.startWithTest + "'");
        }
        return StringUtil.join(criterias, (String)" & ");
    }

    static /* synthetic */ boolean access$000(SuiteFilter x0) {
        return x0.andStrategy;
    }
}

