/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.formatters;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.responders.run.SuiteExecutionReport;
import fitnesse.responders.run.TestExecutionReport;
import fitnesse.responders.run.formatters.BaseFormatter;
import fitnesse.responders.run.formatters.CachingSuiteXmlFormatter;
import fitnesse.responders.run.formatters.CachingSuiteXmlFormatterTest;
import fitnesse.responders.testHistory.PageHistory;
import fitnesse.responders.testHistory.TestHistory;
import fitnesse.responders.testHistory.TestResultRecord;
import fitnesse.testsystems.TestPage;
import fitnesse.testsystems.TestSummary;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.xml.sax.SAXException;
import util.DateTimeUtil;
import util.TimeMeasurement;

public class CachingSuiteXmlFormatterTest {
    private CachingSuiteXmlFormatter formatter;
    private FitNesseContext context;
    private WikiPage root;
    private TestSummary testSummary;
    private TestPage testPage;
    private long testTime;
    private StringWriter writer;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"RooT");
        this.context = FitNesseUtil.makeTestContext((WikiPage)this.root);
        this.testSummary = new TestSummary(1, 2, 3, 4);
        this.testPage = new TestPage(this.root.addChildPage("TestPage"));
        this.writer = new StringWriter();
        this.formatter = new CachingSuiteXmlFormatter(this.context, this.root, (Writer)this.writer);
        this.testTime = DateTimeUtil.getTimeFromString((String)"10/8/1988 10:52:12");
    }

    @Test
    public void canCreateFormatter() throws Exception {
        Assert.assertTrue((boolean)(this.formatter instanceof BaseFormatter));
        Assert.assertEquals((long)0L, (long)this.formatter.getPageHistoryReferences().size());
    }

    @Test
    public void shouldRememberThePageNameAndDateAndRunTime() throws Exception {
        this.formatter = this.newNonWritingCachingSuiteXmlFormatter();
        this.formatter.announceNumberTestsToRun(1);
        TimeMeasurement timeMeasurement = this.constantStartTimeAndElapsedTimeMeasurement(this.testTime, 39L);
        this.formatter.newTestStarted(this.testPage, timeMeasurement);
        this.formatter.testComplete(this.testPage, this.testSummary, timeMeasurement);
        Assert.assertEquals((long)1L, (long)this.formatter.getPageHistoryReferences().size());
        SuiteExecutionReport.PageHistoryReference pageHistoryReference = (SuiteExecutionReport.PageHistoryReference)this.formatter.getPageHistoryReferences().get(0);
        Assert.assertEquals((Object)"TestPage", (Object)pageHistoryReference.getPageName());
        Assert.assertEquals((long)this.testTime, (long)pageHistoryReference.getTime());
        Assert.assertEquals((long)39L, (long)pageHistoryReference.getRunTimeInMillis());
        this.formatter.allTestingComplete(this.constantStartTimeAndElapsedTimeMeasurement(this.testTime, 49L));
        Assert.assertEquals((long)49L, (long)this.formatter.suiteExecutionReport.getTotalRunTimeInMillis());
    }

    @Test
    public void shouldDelegateToReportForTotalRunTime() throws Exception {
        this.formatter.suiteExecutionReport = (SuiteExecutionReport)Mockito.mock(SuiteExecutionReport.class);
        this.formatter.getTotalRunTimeInMillis();
        ((SuiteExecutionReport)Mockito.verify((Object)this.formatter.suiteExecutionReport)).getTotalRunTimeInMillis();
    }

    private CachingSuiteXmlFormatter newNonWritingCachingSuiteXmlFormatter() throws Exception {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private TimeMeasurement constantStartTimeAndElapsedTimeMeasurement(long startTime, long elapsed) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void allTestsCompleteShouldReadTestHistoryAndInvokeVelocity() throws Exception {
        this.formatter.announceNumberTestsToRun(0);
        TestHistory testHistory = (TestHistory)Mockito.mock(TestHistory.class);
        this.formatter.setTestHistoryForTests(testHistory);
        VelocityContext velocityContext = (VelocityContext)Mockito.mock(VelocityContext.class);
        VelocityEngine velocityEngine = (VelocityEngine)Mockito.mock(VelocityEngine.class);
        Writer writer = (Writer)Mockito.mock(Writer.class);
        this.formatter.setVelocityForTests(velocityContext, velocityEngine, writer);
        Template template = (Template)Mockito.mock(Template.class);
        Mockito.when((Object)velocityEngine.getTemplate("suiteXML.vm")).thenReturn((Object)template);
        this.formatter.allTestingComplete(new TimeMeasurement().start().stop());
        ((TestHistory)Mockito.verify((Object)testHistory)).readHistoryDirectory(this.context.getTestHistoryDirectory());
        ((VelocityContext)Mockito.verify((Object)velocityContext)).put("formatter", (Object)this.formatter);
        ((VelocityEngine)Mockito.verify((Object)velocityEngine)).getTemplate("suiteXML.vm");
        ((Template)Mockito.verify((Object)template)).merge((Context)velocityContext, writer);
        ((Writer)Mockito.verify((Object)writer)).close();
    }

    @Test
    public void formatterShouldReturnTestResultsGivenAPageHistoryReference() throws Exception {
        TestHistory testHistory = (TestHistory)Mockito.mock(TestHistory.class);
        PageHistory pageHistory = (PageHistory)Mockito.mock(PageHistory.class);
        TestResultRecord expectedRecord = (TestResultRecord)Mockito.mock(TestResultRecord.class);
        File file = (File)Mockito.mock(File.class);
        TestExecutionReport expectedReport = (TestExecutionReport)Mockito.mock(TestExecutionReport.class);
        3 formatter = new /* Unavailable Anonymous Inner Class!! */;
        Date referenceDate = DateTimeUtil.getDateFromString((String)"12/5/1952 1:19:00");
        formatter.setTestHistoryForTests(testHistory);
        Mockito.when((Object)testHistory.getPageHistory("TestPage")).thenReturn((Object)pageHistory);
        Mockito.when((Object)expectedRecord.getFile()).thenReturn((Object)file);
        Mockito.when((Object)pageHistory.get(referenceDate)).thenReturn((Object)expectedRecord);
        Mockito.when((Object)expectedReport.read(file)).thenReturn((Object)expectedReport);
        SuiteExecutionReport.PageHistoryReference reference = new SuiteExecutionReport.PageHistoryReference("TestPage", referenceDate.getTime(), 27L);
        TestExecutionReport actualReport = formatter.getTestExecutionReport(reference);
        ((TestHistory)Mockito.verify((Object)testHistory)).getPageHistory("TestPage");
        ((PageHistory)Mockito.verify((Object)pageHistory)).get(referenceDate);
        Assert.assertSame((Object)expectedReport, (Object)actualReport);
    }

    @Test
    public void formatterShouldKnowVersionAndRootPage() throws Exception {
        Assert.assertEquals((Object)"RooT", (Object)this.formatter.page.getName());
        Assert.assertEquals((Object)new FitNesseVersion().toString(), (Object)this.formatter.getFitNesseVersion().toString());
    }

    @Test
    public void formatterWithNoTestsShouldHaveZeroPageCounts() throws Exception {
        Assert.assertEquals((Object)new TestSummary(0, 0, 0, 0), (Object)this.formatter.getPageCounts());
    }

    @Test
    public void formatterShouldTallyPageCounts() throws Exception {
        TimeMeasurement timeMeasurement = new TimeMeasurement();
        this.formatter.newTestStarted(this.testPage, timeMeasurement.start());
        this.formatter.testComplete(this.testPage, new TestSummary(32, 0, 0, 0), timeMeasurement.stop());
        Assert.assertEquals((Object)new TestSummary(1, 0, 0, 0), (Object)this.formatter.getPageCounts());
    }

    @Test
    public void shouldIncludeEscapedHtmlIfIncludeHtmlFlagIsSet() throws IOException, SAXException {
        TimeMeasurement timeMeasurement = new TimeMeasurement();
        TestHistory testHistory = (TestHistory)Mockito.mock(TestHistory.class);
        TestResultRecord testResultRecord = (TestResultRecord)Mockito.mock(TestResultRecord.class);
        TestExecutionReport expectedReport = (TestExecutionReport)Mockito.mock(TestExecutionReport.class);
        File file = (File)Mockito.mock(File.class);
        ArrayList<TestExecutionReport.TestResult> testResults = new ArrayList<TestExecutionReport.TestResult>();
        TestExecutionReport.TestResult testResult = new TestExecutionReport.TestResult();
        testResults.add(testResult);
        testResult.content = "<html>blah\" <a class=unquoted>link</a>";
        4 formatter = new /* Unavailable Anonymous Inner Class!! */;
        PageHistory pageHistory = (PageHistory)Mockito.mock(PageHistory.class);
        Mockito.when((Object)testHistory.getPageHistory(Mockito.anyString())).thenReturn((Object)pageHistory);
        Mockito.when((Object)pageHistory.get((Date)Mockito.any(Date.class))).thenReturn((Object)testResultRecord);
        Mockito.when((Object)testResultRecord.getFile()).thenReturn((Object)file);
        Mockito.when((Object)expectedReport.read(file)).thenReturn((Object)expectedReport);
        Mockito.when((Object)expectedReport.getResults()).thenReturn(testResults);
        formatter.setTestHistoryForTests(testHistory);
        formatter.includeHtml();
        formatter.newTestStarted(this.testPage, timeMeasurement.start());
        formatter.testOutputChunk("<html>blah\" <a class=unquoted");
        formatter.testComplete(this.testPage, new TestSummary(1, 0, 0, 0), timeMeasurement.stop());
        formatter.allTestingComplete(timeMeasurement.stop());
        String output = this.writer.toString();
        Assert.assertTrue((String)output, (boolean)output.contains("&lt;html&gt;blah\" &lt;a class=unquoted"));
    }
}

