/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.testHistory.PageHistory;
import fitnesse.testsystems.TestSummary;
import fitnesse.wikitext.parser.WikiWordPath;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import util.FileUtil;

public class TestHistory {
    Map<String, File> pageDirectoryMap = new HashMap();
    public static final String TEST_RESULT_FILE_DATE_PATTERN = "yyyyMMddHHmmss";

    public void readHistoryDirectory(File historyDirectory) {
        File[] pageDirectories;
        for (File file : pageDirectories = FileUtil.getDirectoryListing((File)historyDirectory)) {
            if (!this.isValidFile(file)) continue;
            this.pageDirectoryMap.put(file.getName(), file);
        }
    }

    private boolean isValidFile(File file) {
        return file.isDirectory() && file.list().length > 0 && WikiWordPath.isWikiWord((String)file.getName());
    }

    public Set<String> getPageNames() {
        return new TreeSet<String>(this.pageDirectoryMap.keySet());
    }

    public PageHistory getPageHistory(String pageName) {
        File pageHistoryDirectory = (File)this.pageDirectoryMap.get(pageName);
        if (pageHistoryDirectory == null) {
            return null;
        }
        PageHistory pageHistory = new PageHistory(pageHistoryDirectory);
        if (pageHistory.size() == 0) {
            return null;
        }
        return pageHistory;
    }

    public void readPageHistoryDirectory(File historyDirectory, String pageName) {
        File[] pageDirectories;
        for (File file : pageDirectories = FileUtil.getDirectoryListing((File)historyDirectory)) {
            if (!this.isValidFile(file) || !file.getName().startsWith(pageName)) continue;
            this.pageDirectoryMap.put(file.getName(), file);
        }
    }

    public static String makeResultFileName(TestSummary summary, long time) {
        SimpleDateFormat format = new SimpleDateFormat(TEST_RESULT_FILE_DATE_PATTERN);
        String datePart = format.format(new Date(time));
        return String.format("%s_%d_%d_%d_%d.xml", datePart, summary.getRight(), summary.getWrong(), summary.getIgnores(), summary.getExceptions());
    }
}

