/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.BooleanConverter;
import fitnesse.slim.converters.ConverterRegistry;
import fitnesse.slim.converters.DateConverter;
import fitnesse.slim.converters.EnumConverter;
import fitnesse.slim.test.AnEnum;
import fitnesse.slim.test.AnotherEnum;
import org.junit.Assert;
import org.junit.Test;

public class ConverterTest {
    @Test
    public void convertDate() throws Exception {
        this.assertConverts((Converter)new DateConverter(), "05-May-2009");
    }

    @Test
    public void convertDateWithoutLeadingZero() throws Exception {
        this.assertConverts("05-May-2009", (Converter)new DateConverter(), "5-May-2009");
    }

    @Test
    public void convertBooleanTrue() throws Exception {
        BooleanConverter converter = new BooleanConverter();
        this.assertConverts((Converter)converter, "true");
        this.assertConverts("true", (Converter)converter, "True");
        this.assertConverts("true", (Converter)converter, "TRUE");
        this.assertConverts("true", (Converter)converter, "YES");
        this.assertConverts("true", (Converter)converter, "yes");
    }

    @Test
    public void convertBooleanFalse() throws Exception {
        BooleanConverter converter = new BooleanConverter();
        this.assertConverts((Converter)converter, "false");
        this.assertConverts("false", (Converter)converter, "FALSE");
        this.assertConverts("false", (Converter)converter, "False");
        this.assertConverts("false", (Converter)converter, "no");
        this.assertConverts("false", (Converter)converter, "NO");
        this.assertConverts("false", (Converter)converter, "0");
        this.assertConverts("false", (Converter)converter, "1");
        this.assertConverts("false", (Converter)converter, "x");
    }

    @Test
    public void defaultEnumConversion() {
        Assert.assertTrue((boolean)(ConverterRegistry.getConverterForClass(AnEnum.class) instanceof EnumConverter));
    }

    @Test
    public void convertEnum() throws Exception {
        this.assertConverts((Converter)new EnumConverter(AnEnum.class), "ONE_VALUE");
    }

    @Test
    public void usesEditorForEnum() throws Exception {
        this.assertConverts("enum property editor called with \"some value\"", ConverterRegistry.getConverterForClass(AnotherEnum.class), "some value");
    }

    private <T> void assertConverts(Converter<T> converter, String value) {
        this.assertConverts(value, converter, value);
    }

    private <T> void assertConverts(String expected, Converter<T> converter, String value) {
        Assert.assertEquals((Object)expected, (Object)converter.toString(converter.fromString(value)));
    }
}

