/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.Jsr223Bridge;
import fitnesse.slim.StatementExecutorInterface;
import java.io.PrintWriter;
import java.io.StringWriter;

public abstract class Jsr223StatementExecutor
implements StatementExecutorInterface {
    protected Jsr223Bridge bridge;
    private Object statementExecutorProxy;

    public Jsr223StatementExecutor(Jsr223Bridge bridge) {
        this.bridge = bridge;
        this.statementExecutorProxy = bridge.getStatementExecutor();
    }

    protected Object getStatementExecutorProxy() {
        return this.statementExecutorProxy;
    }

    public void addPath(String path) {
        this.callMethod("addPath", new Object[]{path});
    }

    public Object call(String instanceName, String methodName, Object ... args) {
        return this.callMethod("call", new Object[]{instanceName, methodName, args});
    }

    public void create(String instanceName, String className, Object[] args) {
        this.callMethod("create", new Object[]{instanceName, className, args});
    }

    public Object getInstance(String instanceName) {
        return this.callMethod("getInstance", new Object[]{instanceName});
    }

    public void setVariable(String name, Object value) {
        this.callMethod("setVariable", new Object[]{name, value});
    }

    public boolean stopHasBeenRequested() {
        return (Boolean)this.callMethod("stopHasBeenRequested", new Object[0]);
    }

    public void reset() {
        this.callMethod("reset", new Object[0]);
    }

    protected Object callMethod(String method, Object ... args) {
        try {
            return this.bridge.invokeMethod(this.getStatementExecutorProxy(), method, args);
        }
        catch (Throwable e) {
            return this.exceptionToString(e);
        }
    }

    private String exceptionToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stringWriter);
        exception.printStackTrace(pw);
        return "__EXCEPTION__:" + stringWriter.toString();
    }
}

