/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.converters.MapEditor;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapConverterTest {
    private MapEditor converter;
    private Map<String, String> result;

    @Before
    public void setup() {
        this.converter = new MapEditor();
    }

    @Test
    public void fromEmptyString_shouldCreateEmptyMap() throws Exception {
        this.makeMap("");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }

    private void makeMap(String inputString) {
        this.result = (Map)this.converter.fromString(inputString);
    }

    @Test
    public void fromGarbageString_shouldCreateEmptyMap() throws Exception {
        this.makeMap("sdfwewdfsdfwefsdfsdfswe");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }

    @Test
    public void fromEmptyTable_shouldCreateEmptyMap() throws Exception {
        this.makeMap("<table></table>");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }

    @Test
    public void fromTableWithNoColumns_shouldCreateEmptyMap() throws Exception {
        this.makeMap("<table><tr></tr><tr></tr></table>");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }

    @Test
    public void fromTableWithOneColumn_shouldCreateEmptyMap() throws Exception {
        this.makeMap("<table><tr><td>0</td></tr></table>");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }

    @Test
    public void fromTableWithMoreThanTwoColumns_shouldCreateEmptyMap() throws Exception {
        this.makeMap("<table><tr>  <td>0</td>  <td>0</td>  <td>0</td></tr></table>");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }

    @Test
    public void fromTableWithTwoColumnsAndOneRow_shouldCreateMapWithOneEntry() throws Exception {
        this.makeMap("<table><tr>  <td>name</td>  <td>Bob</td></tr></table>");
        Assert.assertEquals((long)1L, (long)this.result.size());
        Assert.assertEquals((Object)"Bob", this.result.get("name"));
    }

    @Test
    public void fromTableWithTwoColumnsAndTwoRows_shouldCreateMapWithTwoEntries() throws Exception {
        this.makeMap("<table><tr>  <td>name</td>  <td>Bob</td></tr><tr>  <td>address</td>  <td>here</td></tr></table>");
        Assert.assertEquals((long)2L, (long)this.result.size());
        Assert.assertEquals((Object)"Bob", this.result.get("name"));
        Assert.assertEquals((Object)"here", this.result.get("address"));
    }

    @Test
    public void fromTwoValidTables_shouldCreateEmptyMap() throws Exception {
        this.makeMap("<table><tr>  <td>name</td>  <td>Bob</td></tr></table><table><tr>  <td>name</td>  <td>Bob</td></tr></table>");
        Assert.assertEquals((long)0L, (long)this.result.size());
    }
}

