/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.instructions;

import fitnesse.slim.instructions.SystemExitSecurityManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.RegexTestCase;

public class SystemExitSecurityManagerTest {
    SecurityManager oldSecurityManager;
    SecurityManager securityManager;

    @Before
    public void setup() {
        this.oldSecurityManager = System.getSecurityManager();
        this.securityManager = new SystemExitSecurityManager(this.oldSecurityManager);
        System.setSecurityManager(this.securityManager);
    }

    @After
    public void teardown() {
        System.setSecurityManager(this.oldSecurityManager);
    }

    @Test
    public void shouldThrowExceptionWhenSystemExitIsCalled() {
        try {
            System.exit(0);
            Assert.fail((String)"should have thrown exception");
        }
        catch (SystemExitSecurityManager.SystemExitException systemExitException) {
            // empty catch block
        }
    }

    @Test
    public void shouldIncludeExitCode() {
        try {
            System.exit(42);
            Assert.fail((String)"should have thrown exception");
        }
        catch (SystemExitSecurityManager.SystemExitException e) {
            RegexTestCase.assertMatches((String)"system exit with exit code 42", (String)e.getMessage());
        }
    }
}

