/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems;

import fitnesse.responders.PageFactory;
import fitnesse.testsystems.CommandRunner;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import util.Clock;

public class ExecutionLog {
    public static final String ErrorLogName = "ErrorLogs";
    private PageCrawler crawler;
    private final String errorLogPageName;
    private final WikiPagePath errorLogPagePath;
    private final WikiPage testPage;
    private final CommandRunner runner;
    private final List<Throwable> exceptions = new LinkedList();

    public ExecutionLog(WikiPage testPage, CommandRunner client) {
        this.testPage = testPage;
        this.runner = client;
        this.crawler = testPage.getPageCrawler();
        this.errorLogPagePath = this.crawler.getFullPath(testPage).addNameToFront(ErrorLogName);
        this.errorLogPageName = PathParser.render((WikiPagePath)this.errorLogPagePath);
    }

    void addException(Throwable e) {
        this.exceptions.add(e);
    }

    String buildLogContent(PageFactory pageFactory) {
        VelocityContext context = new VelocityContext();
        context.put("currentDate", (Object)this.makeDateFormat().format(Clock.currentDate()));
        context.put("testPage", (Object)("." + PathParser.render((WikiPagePath)this.crawler.getFullPath(this.testPage))));
        context.put("runner", (Object)this.runner);
        this.exceptions.addAll(this.runner.getExceptions());
        context.put("exceptions", (Object)this.exceptions);
        return pageFactory.render(context, "executionLog.vm");
    }

    int exceptionCount() {
        return this.exceptions.size();
    }

    String getErrorLogPageName() {
        return this.errorLogPageName;
    }

    boolean hasCapturedOutput() {
        return this.runner.wroteToErrorStream() || this.runner.wroteToOutputStream();
    }

    public int getExitCode() {
        return this.runner.getExitCode();
    }

    public CommandRunner getCommandRunner() {
        return this.runner;
    }

    private SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("h:mm:ss a (z) 'on' EEEE, MMMM d, yyyy");
    }
}

