/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.fit;

import fit.Counts;
import fit.FitProtocol;
import fitnesse.testsystems.TestSummary;
import fitnesse.testsystems.TestSystemListener;
import fitnesse.testsystems.fit.FitClient;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import util.StreamReader;

public class FitClient {
    protected TestSystemListener listener;
    protected Socket fitSocket;
    private OutputStream fitInput;
    private StreamReader fitOutput;
    private volatile int sent = 0;
    private volatile int received = 0;
    private volatile boolean isDoneSending = false;
    protected volatile boolean killed = false;
    protected Thread fitListeningThread;

    public FitClient(TestSystemListener listener) {
        this.listener = listener;
    }

    public synchronized void acceptSocket(Socket socket) throws IOException, InterruptedException {
        this.checkForPulse();
        this.fitSocket = socket;
        this.fitInput = this.fitSocket.getOutputStream();
        FitProtocol.writeData((String)"", (OutputStream)this.fitInput);
        this.fitOutput = new StreamReader(this.fitSocket.getInputStream());
        this.fitListeningThread = new Thread((Runnable)new FitListeningRunnable(this, null), "FitClient fitOutput");
        this.fitListeningThread.start();
    }

    public void send(String data) throws IOException, InterruptedException {
        this.checkForPulse();
        FitProtocol.writeData((String)data, (OutputStream)this.fitInput);
        ++this.sent;
    }

    public void done() throws IOException, InterruptedException {
        this.checkForPulse();
        FitProtocol.writeSize((int)0, (OutputStream)this.fitInput);
        this.isDoneSending = true;
    }

    public void join() {
        if (this.fitListeningThread != null) {
            try {
                this.fitListeningThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void kill() {
        this.killed = true;
        if (this.fitListeningThread != null) {
            this.fitListeningThread.interrupt();
        }
    }

    public synchronized boolean isSuccessfullyStarted() {
        return this.fitSocket != null;
    }

    public void exceptionOccurred(Exception e) {
        this.listener.exceptionOccurred((Throwable)e);
    }

    protected void checkForPulse() throws InterruptedException {
        if (this.killed) {
            throw new InterruptedException("FitClient was killed");
        }
    }

    private void listenToFit() {
        try {
            this.attemptToListenToFit();
        }
        catch (Exception e) {
            this.exceptionOccurred(e);
        }
    }

    private void attemptToListenToFit() throws Exception {
        while (!this.finishedReading()) {
            int size = FitProtocol.readSize((StreamReader)this.fitOutput);
            if (size != 0) {
                String readValue = this.fitOutput.read(size);
                if (this.fitOutput.byteCount() < size) {
                    throw new Exception("I was expecting " + size + " bytes but I only got " + this.fitOutput.byteCount());
                }
                this.listener.testOutputChunk(readValue);
                continue;
            }
            Counts counts = FitProtocol.readCounts((StreamReader)this.fitOutput);
            TestSummary summary = new TestSummary();
            summary.right = counts.right;
            summary.wrong = counts.wrong;
            summary.ignores = counts.ignores;
            summary.exceptions = counts.exceptions;
            this.listener.testComplete(summary);
            ++this.received;
        }
    }

    private boolean finishedReading() {
        while (this.stateIndeterminate()) {
            this.shortSleep();
        }
        return this.isDoneSending && this.received == this.sent;
    }

    private boolean stateIndeterminate() {
        return this.received == this.sent && !this.isDoneSending;
    }

    private void shortSleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ void access$100(FitClient x0) {
        x0.listenToFit();
    }
}

