/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.tables.Expectation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Assertion {
    private final Instruction instruction;
    private final Expectation expectation;

    Assertion(Instruction instruction, Expectation expectation) {
        this.instruction = instruction;
        this.expectation = expectation;
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public static List<Instruction> getInstructions(List<Assertion> assertions) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>(assertions.size());
        for (Assertion a : assertions) {
            if (a.getInstruction() == Instruction.NOOP_INSTRUCTION) continue;
            instructions.add(a.getInstruction());
        }
        return instructions;
    }

    public static void evaluateExpectations(List<Assertion> assertions, Map<String, Object> results) {
        for (Assertion a : assertions) {
            Object returnValue = results.get(a.getInstruction().getId());
            a.getExpectation().evaluateExpectation(returnValue);
        }
    }
}

