/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.results.TestResult;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.Expectation;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SyntaxError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import util.ListUtility;

public class QueryTable
extends SlimTable {
    protected List<String> fieldNames = new ArrayList();
    private String queryId;
    private String tableInstruction;

    public QueryTable(Table table, String id, SlimTestContext testContext) {
        super(table, id, testContext);
    }

    protected String getTableType() {
        return "queryTable";
    }

    public boolean matches(String actual, String expected) {
        if (actual == null || expected == null) {
            return false;
        }
        if (actual.equals(this.replaceSymbols(expected))) {
            return true;
        }
        SlimTable.Comparator c = new SlimTable.Comparator((SlimTable)this, actual, expected);
        return c.matches();
    }

    public TestResult matchMessage(String actual, String expected) {
        if (actual == null) {
            return TestResult.fail((String)"NULL");
        }
        if (actual.equals(this.replaceSymbols(expected))) {
            return TestResult.pass((String)this.replaceSymbolsWithFullExpansion(expected));
        }
        SlimTable.Comparator c = new SlimTable.Comparator((SlimTable)this, actual, expected);
        return c.evaluate();
    }

    public List<Assertion> getAssertions() throws SyntaxError {
        if (this.table.getRowCount() < 2) {
            throw new SyntaxError("Query tables must have at least two rows.");
        }
        this.assignColumns();
        Assertion make = this.constructFixture(this.getFixtureName());
        Assertion ti = this.makeAssertion(this.callFunction(this.getTableName(), "table", new Object[]{this.tableAsList()}), (Expectation)new SlimTable.SilentReturnExpectation((SlimTable)this, 0, 0));
        Assertion qi = this.makeAssertion(this.callFunction(this.getTableName(), "query", new Object[0]), (Expectation)new QueryTableExpectation(this));
        this.tableInstruction = ti.getInstruction().getId();
        this.queryId = qi.getInstruction().getId();
        return ListUtility.list((Object[])new Assertion[]{make, ti, qi});
    }

    public boolean shouldIgnoreException(String resultKey, String resultString) {
        boolean isTableInstruction = resultKey.equals(this.tableInstruction);
        boolean isNoMethodException = resultString.contains("NO_METHOD_IN_CLASS");
        return isTableInstruction && isNoMethodException;
    }

    private void assignColumns() {
        int cols = this.table.getColumnCountInRow(1);
        for (int col = 0; col < cols; ++col) {
            this.fieldNames.add(this.table.getCellContents(col, 1));
        }
    }

    protected ExecutionResult scanRowsForMatches(List<Object> queryResultList) {
        QueryResults queryResults = new QueryResults(this, queryResultList);
        int rows = this.table.getRowCount();
        for (int tableRow = 2; tableRow < rows; ++tableRow) {
            this.scanRowForMatch(tableRow, queryResults);
        }
        return this.markSurplusRows(queryResults);
    }

    private ExecutionResult markSurplusRows(QueryResults queryResults) {
        List unmatchedRows = queryResults.getUnmatchedRows();
        ExecutionResult result = ExecutionResult.PASS;
        Iterator i$ = unmatchedRows.iterator();
        while (i$.hasNext()) {
            int unmatchedRow = (Integer)i$.next();
            List surplusRow = queryResults.getList(this.fieldNames, unmatchedRow);
            int newTableRow = this.table.addRow(surplusRow);
            TestResult testResult = TestResult.fail((String)((String)surplusRow.get(0)), null, (String)"surplus");
            this.table.updateContent(0, newTableRow, testResult);
            this.getTestContext().increment(ExecutionResult.FAIL);
            this.markMissingFields(surplusRow, newTableRow);
            result = ExecutionResult.FAIL;
        }
        return result;
    }

    private void markMissingFields(List<String> surplusRow, int newTableRow) {
        for (int col = 0; col < surplusRow.size(); ++col) {
            String surplusField = surplusRow.get(col);
            if (surplusField != null) continue;
            String fieldName = (String)this.fieldNames.get(col);
            TestResult testResult = TestResult.fail((String)String.format("field %s not present", fieldName));
            this.table.updateContent(col, newTableRow, testResult);
            this.getTestContext().increment(testResult.getExecutionResult());
        }
    }

    protected void scanRowForMatch(int tableRow, QueryResults queryResults) {
        int matchedRow = queryResults.findBestMatch(tableRow);
        if (matchedRow == -1) {
            this.replaceAllvariablesInRow(tableRow);
            TestResult testResult = TestResult.fail(null, (String)this.table.getCellContents(0, tableRow), (String)"missing");
            this.table.updateContent(0, tableRow, testResult);
            this.getTestContext().increment(testResult.getExecutionResult());
        } else {
            this.markFieldsInMatchedRow(tableRow, matchedRow, queryResults);
        }
    }

    protected void replaceAllvariablesInRow(int tableRow) {
        int columns = this.table.getColumnCountInRow(tableRow);
        for (int col = 0; col < columns; ++col) {
            String contents = this.table.getCellContents(col, tableRow);
            this.table.substitute(col, tableRow, this.replaceSymbolsWithFullExpansion(contents));
        }
    }

    protected void markFieldsInMatchedRow(int tableRow, int matchedRow, QueryResults queryResults) {
        int columns = this.table.getColumnCountInRow(tableRow);
        for (int col = 0; col < columns; ++col) {
            this.markField(tableRow, matchedRow, col, queryResults);
        }
    }

    protected TestResult markField(int tableRow, int matchedRow, int col, QueryResults queryResults) {
        TestResult testResult;
        if (col >= this.fieldNames.size()) {
            return null;
        }
        String fieldName = (String)this.fieldNames.get(col);
        String actualValue = queryResults.getCell(fieldName, matchedRow);
        String expectedValue = this.table.getCellContents(col, tableRow);
        if (actualValue == null) {
            testResult = TestResult.fail((String)String.format("field %s not present", fieldName), (String)expectedValue);
        } else if (expectedValue == null || expectedValue.length() == 0) {
            testResult = TestResult.ignore((String)actualValue);
        } else {
            testResult = this.matchMessage(actualValue, expectedValue);
            if (testResult == null) {
                testResult = TestResult.fail((String)actualValue, (String)this.replaceSymbolsWithFullExpansion(expectedValue));
            } else if (testResult.getExecutionResult() == ExecutionResult.PASS) {
                testResult = this.markMatch(tableRow, matchedRow, col, testResult.getMessage());
            }
        }
        this.table.updateContent(col, tableRow, testResult);
        this.getTestContext().increment(testResult.getExecutionResult());
        return testResult;
    }

    protected TestResult markMatch(int tableRow, int matchedRow, int col, String message) {
        return TestResult.pass((String)message);
    }

    static /* synthetic */ String access$000(QueryTable x0) {
        return x0.queryId;
    }
}

