/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimClient;
import fitnesse.slim.instructions.CallAndAssignInstruction;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import fitnesse.wikitext.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public class ScriptTableTest {
    private WikiPage root;
    private List<Assertion> assertions;
    private final String scriptTableHeader = "|Script|\n";
    public ScriptTable st;
    private SlimTestContextImpl testContext;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.assertions = new ArrayList();
    }

    private ScriptTable buildInstructionsForWholeTable(String pageContents) throws Exception {
        this.st = this.makeScriptTable(pageContents);
        this.assertions.addAll(this.st.getAssertions());
        return this.st;
    }

    private ScriptTable makeScriptTable(String tableText) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        this.testContext = new SlimTestContextImpl();
        return new ScriptTable(t, "id", (SlimTestContext)this.testContext);
    }

    private void assertScriptResults(String scriptStatements, List<List<?>> scriptResults, String table) throws Exception {
        this.buildInstructionsFor(scriptStatements);
        List resultList = ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "OK"})});
        resultList.addAll(scriptResults);
        Map pseudoResults = SlimClient.resultToMap((List)resultList);
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)table, (Object)Utils.unescapeWiki((String)this.st.getTable().toString()));
    }

    private void buildInstructionsFor(String scriptStatements) throws Exception {
        this.buildInstructionsForWholeTable("|Script|\n" + scriptStatements);
    }

    private List<Instruction> instructions() {
        return Assertion.getInstructions((List)this.assertions);
    }

    @Test
    public void instructionsForScriptTable() throws Exception {
        this.buildInstructionsFor("||\n");
        Assert.assertEquals((long)0L, (long)this.assertions.size());
    }

    @Test
    public void startStatement() throws Exception {
        this.buildInstructionsFor("|start|Bob|\n");
        List expectedInstructions = ListUtility.list((Object[])new MakeInstruction[]{new MakeInstruction("scriptTable_id_0", "scriptTableActor", "Bob")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void scriptWithActor() throws Exception {
        this.buildInstructionsForWholeTable("|script|Bob|\n");
        List expectedInstructions = ListUtility.list((Object[])new MakeInstruction[]{new MakeInstruction("scriptTable_id_0", "scriptTableActor", "Bob")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void startStatementWithArguments() throws Exception {
        this.buildInstructionsFor("|start|Bob martin|x|y|\n");
        List expectedInstructions = ListUtility.list((Object[])new MakeInstruction[]{new MakeInstruction("scriptTable_id_0", "scriptTableActor", "BobMartin", new Object[]{"x", "y"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void scriptStatementWithArguments() throws Exception {
        this.buildInstructionsForWholeTable("|script|Bob martin|x|y|\n");
        List expectedInstructions = ListUtility.list((Object[])new MakeInstruction[]{new MakeInstruction("scriptTable_id_0", "scriptTableActor", "BobMartin", new Object[]{"x", "y"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void simpleFunctionCall() throws Exception {
        this.buildInstructionsFor("|function|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void functionCallWithOneArgument() throws Exception {
        this.buildInstructionsFor("|function|arg|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void functionCallWithOneArgumentAndTrailingName() throws Exception {
        this.buildInstructionsFor("|function|arg|trail|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "functionTrail", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void complexFunctionCallWithManyArguments() throws Exception {
        this.buildInstructionsFor("|eat|3|meals with|12|grams protein|3|grams fat |\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "eatMealsWithGramsProteinGramsFat", new Object[]{"3", "12", "3"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void functionCallWithSequentialArgumentProcessingAndOneArgument() throws Exception {
        this.buildInstructionsFor("|function;|arg0|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg0"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void functionCallWithSequentialArgumentProcessingAndMultipleArguments() throws Exception {
        this.buildInstructionsFor("|function;|arg0|arg1|arg2|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg0", "arg1", "arg2"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void functionCallWithSequentialArgumentProcessingEmbedded() throws Exception {
        this.buildInstructionsFor("|set name|Marisa|department and title;|QA|Tester|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "setNameDepartmentAndTitle", new Object[]{"Marisa", "QA", "Tester"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void functionCallWithSequentialArgumentProcessingEmbedded2() throws Exception {
        this.buildInstructionsFor("|set name|Marisa|department|QA|title and length of employment;|Tester|2 years|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "setNameDepartmentTitleAndLengthOfEmployment", new Object[]{"Marisa", "QA", "Tester", "2 years"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void checkWithFunction() throws Exception {
        this.buildInstructionsFor("|check|function|arg|result|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void checkNotWithFunction() throws Exception {
        this.buildInstructionsFor("|check not|function|arg|result|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void checkWithFunctionAndTrailingName() throws Exception {
        this.buildInstructionsFor("|check|function|arg|trail|result|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "functionTrail", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void rejectWithFunctionCall() throws Exception {
        this.buildInstructionsFor("|reject|function|arg|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void ensureWithFunctionCall() throws Exception {
        this.buildInstructionsFor("|ensure|function|arg|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void showWithFunctionCall() throws Exception {
        this.buildInstructionsFor("|show|function|arg|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void setSymbol() throws Exception {
        this.buildInstructionsFor("|$V=|function|arg|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallAndAssignInstruction[]{new CallAndAssignInstruction("scriptTable_id_0", "V", "scriptTableActor", "function", new Object[]{"arg"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void useSymbol() throws Exception {
        this.buildInstructionsFor("|function|$V|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0", "scriptTableActor", "function", new Object[]{"$V"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void noteDoesNothing() throws Exception {
        this.buildInstructionsFor("|note|blah|blah|\n");
        List expectedInstructions = Collections.emptyList();
        Assert.assertEquals(expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void initialBlankCellDoesNothing() throws Exception {
        this.buildInstructionsFor("||blah|blah|\n");
        List expectedInstructions = Collections.emptyList();
        Assert.assertEquals(expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void initialHashDoesNothing() throws Exception {
        this.buildInstructionsFor("|!-#comment-!|blah|blah|\n");
        List expectedInstructions = Collections.emptyList();
        Assert.assertEquals(expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void initialStarDoesNothing() throws Exception {
        this.buildInstructionsFor("|*comment|blah|blah|\n");
        List expectedInstructions = Collections.emptyList();
        Assert.assertEquals(expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void voidActionHasNoEffectOnColor() throws Exception {
        this.assertScriptResults("|func|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "/__VOID__/"})}), "[[Script], [func]]");
    }

    @Test
    public void actionReturningNullHasNoEffectOnColor() throws Exception {
        this.assertScriptResults("|func|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "null"})}), "[[Script], [func]]");
    }

    @Test
    public void trueActionPasses() throws Exception {
        this.assertScriptResults("|func|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "true"})}), "[[Script], [pass(func)]]");
    }

    @Test
    public void falseActionFails() throws Exception {
        this.assertScriptResults("|func|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "false"})}), "[[Script], [fail(func)]]");
    }

    @Test
    public void checkPasses() throws Exception {
        this.assertScriptResults("|check|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "3"})}), "[[Script], [check, func, pass(3)]]");
    }

    @Test
    public void checkNotFails() throws Exception {
        this.assertScriptResults("|check not|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "3"})}), "[[Script], [check not, func, fail(3)]]");
    }

    @Test
    public void checkFails() throws Exception {
        this.assertScriptResults("|check|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "4"})}), "[[Script], [check, func, fail(a=4;e=3)]]");
    }

    @Test
    public void checkNotPasses() throws Exception {
        this.assertScriptResults("|check not|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "4"})}), "[[Script], [check not, func, pass(a=4;e=3)]]");
    }

    @Test
    public void ensurePasses() throws Exception {
        this.assertScriptResults("|ensure|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "true"})}), "[[Script], [pass(ensure), func, 3]]");
    }

    @Test
    public void ensureFails() throws Exception {
        this.assertScriptResults("|ensure|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "false"})}), "[[Script], [fail(ensure), func, 3]]");
    }

    @Test
    public void rejectPasses() throws Exception {
        this.assertScriptResults("|reject|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "false"})}), "[[Script], [pass(reject), func, 3]]");
    }

    @Test
    public void rejectFails() throws Exception {
        this.assertScriptResults("|reject|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "true"})}), "[[Script], [fail(reject), func, 3]]");
    }

    @Test
    public void show() throws Exception {
        this.assertScriptResults("|show|func|3|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "kawabunga"})}), "[[Script], [show, func, 3, kawabunga]]");
    }

    @Test
    public void symbolReplacement() throws Exception {
        this.assertScriptResults("|$V=|function|\n|check|funcion|$V|$V|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "3"}), ListUtility.list((String[])new String[]{"scriptTable_id_1", "3"})}), "[[Script], [$V<-[3], function], [check, funcion, $V->[3], pass($V->[3])]]");
    }

    @Test
    public void sameSymbolTwiceReplacement() throws Exception {
        this.assertScriptResults("|$V=|function|\n|check|funcion|$V $V|$V|\n", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "3"}), ListUtility.list((String[])new String[]{"scriptTable_id_1", "3"})}), "[[Script], [$V<-[3], function], [check, funcion, $V->[3] $V->[3], pass($V->[3])]]");
    }
}

