/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.DecisionTable;
import fitnesse.testsystems.slim.tables.ImportTable;
import fitnesse.testsystems.slim.tables.LibraryTable;
import fitnesse.testsystems.slim.tables.OrderedQueryTable;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableFactory;
import fitnesse.testsystems.slim.tables.SubsetQueryTable;
import fitnesse.testsystems.slim.tables.TableTable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SlimTableFactoryTest {
    private SlimTableFactory slimTableFactory;
    private Table table;
    private Map<String, Class<? extends SlimTable>> map;

    @Before
    public void setUp() {
        this.slimTableFactory = new SlimTableFactory();
        this.table = (Table)Mockito.mock(Table.class);
        this.map = new HashMap();
        this.map.put("dt:", DecisionTable.class);
        this.map.put("dT:", DecisionTable.class);
        this.map.put("decision:", DecisionTable.class);
        this.map.put("ordered query:", OrderedQueryTable.class);
        this.map.put("subset query:", SubsetQueryTable.class);
        this.map.put("query:", QueryTable.class);
        this.map.put("table:", TableTable.class);
        this.map.put("script", ScriptTable.class);
        this.map.put("scenario", ScenarioTable.class);
        this.map.put("import", ImportTable.class);
        this.map.put("something", DecisionTable.class);
        this.map.put("library", LibraryTable.class);
    }

    @Test
    public void shouldCreateCorrectSlimTableForTablesType() {
        for (Map.Entry entry : this.map.entrySet()) {
            this.assertThatTableTypeCreateSlimTableType((String)entry.getKey(), (Class)entry.getValue());
        }
    }

    private void assertThatTableTypeCreateSlimTableType(String tableType, Class<? extends SlimTable> expectedClass) {
        Mockito.when((Object)this.table.getCellContents(0, 0)).thenReturn((Object)tableType);
        SlimTable slimTable = this.slimTableFactory.makeSlimTable(this.table, "0", (SlimTestContext)new SlimTestContextImpl());
        String message = "should have created a " + expectedClass + " for tabletype: " + tableType + " but was " + slimTable.getClass();
        Assert.assertThat((String)message, (Object)slimTable, (Matcher)CoreMatchers.instanceOf(expectedClass));
    }

    @Test
    public void checkTableTypeDefineUsedForTable() {
        this.assertThatTableTypeImportWorks("My query table", "Query", "My query Table", QueryTable.class);
        this.assertThatTableTypeImportWorks("Graceful Difference 1", "Query", "GracefulDifference1", QueryTable.class);
        this.assertThatTableTypeImportWorks("GracefulDifference2", "Query", "Graceful Difference 2", QueryTable.class);
        this.assertThatTableTypeImportWorks("A Table table", "Table", "A Table table", TableTable.class);
        this.assertThatTableTypeImportWorks("As is allowed", "as Table", "As is allowed", TableTable.class);
        this.assertThatTableTypeImportWorks("Colon is okay too", "as:Table", "Colon is okay too", TableTable.class);
        this.assertThatTableTypeImportWorks("", "", "This should be default", DecisionTable.class);
    }

    @Test
    public void checkTableTypeDefinesIgnoredIfDifferentSpecified() {
        this.assertThatTableTypeImportWorks("OverrideTable", "as Table", "dt: Override Table", DecisionTable.class);
        this.assertThatTableTypeImportWorks("MakeQuery", "as Table", "query: Make Query", QueryTable.class);
    }

    private void assertThatTableTypeImportWorks(String importName, String importTypedescription, String tableName, Class<? extends SlimTable> tableClass) {
        this.addTableTypeImport(importName, importTypedescription);
        this.assertThatTableTypeCreateSlimTableType(tableName, tableClass);
    }

    private void addTableTypeImport(String tablename, String type) {
        Mockito.when((Object)this.table.getCellContents(0, 0)).thenReturn((Object)"Define Table Type");
        Mockito.when((Object)this.table.getCellContents(0, 1)).thenReturn((Object)tablename);
        Mockito.when((Object)this.table.getCellContents(1, 1)).thenReturn((Object)type);
        Mockito.when((Object)this.table.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.table.getColumnCountInRow(0)).thenReturn((Object)1);
        Mockito.when((Object)this.table.getColumnCountInRow(1)).thenReturn((Object)2);
        this.slimTableFactory.makeSlimTable(this.table, "0", (SlimTestContext)new SlimTestContextImpl());
    }
}

