/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimClient;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.TableTable;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public class TableTableTest {
    private WikiPage root;
    private List<Assertion> assertions;
    private final String tableTableHeader = "|Table:fixture|argument|\n";
    public TableTable tt;
    private SlimTestContextImpl testContext;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.assertions = new ArrayList();
    }

    private TableTable makeTableTableAndBuildInstructions(String pageContents) throws Exception {
        this.tt = this.makeTableTable(pageContents);
        this.assertions.addAll(this.tt.getAssertions());
        return this.tt;
    }

    private TableTable makeTableTable(String tableText) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        this.testContext = new SlimTestContextImpl();
        return new TableTable(t, "id", (SlimTestContext)this.testContext);
    }

    private void assertTableResults(String tableRows, List<Object> tableResults, String table) throws Exception {
        this.makeTableTableAndBuildInstructions("|Table:fixture|argument|\n" + tableRows);
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"tableTable_id_0", "OK"}), ListUtility.list((Object[])new Object[]{"tableTable_id_1", tableResults})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)table, (Object)this.tt.getTable().toString());
    }

    private List<Instruction> instructions() {
        return Assertion.getInstructions((List)this.assertions);
    }

    @Test
    public void instructionsForEmptyTableTable() throws Exception {
        this.makeTableTableAndBuildInstructions("|Table:fixture|argument|\n");
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction("tableTable_id_0", "tableTable_id", "fixture", new Object[]{"argument"}), new CallInstruction("tableTable_id_1", "tableTable_id", "doTable", new Object[]{ListUtility.list()})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void instructionsForTableTable() throws Exception {
        this.makeTableTableAndBuildInstructions("|Table:fixture|argument|\n|a|b|\n|x|y|\n");
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction("tableTable_id_0", "tableTable_id", "fixture", new Object[]{"argument"}), new CallInstruction("tableTable_id_1", "tableTable_id", "doTable", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"a", "b"}), ListUtility.list((String[])new String[]{"x", "y"})})})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void oneRowThatPassesUnchanged() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"pass", "pass"})}), "[[pass(Table:fixture), argument], [pass(2), pass(4)]]");
    }

    @Test
    public void oneRowThatPassesChanged() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"pass:x", "pass:y"})}), "[[pass(Table:fixture), argument], [pass(x), pass(y)]]");
    }

    @Test
    public void oneRowThatPassesWithManyColons() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"pass:x:z", "pass:http://me"})}), "[[pass(Table:fixture), argument], [pass(x:z), pass(http://me)]]");
    }

    @Test
    public void oneRowThatImplicitlyFails() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"bad", "boy"})}), "[[pass(Table:fixture), argument], [fail(bad), fail(boy)]]");
    }

    @Test
    public void oneRowThatImplicitlyFailsWithColon() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"x:bad", "x:boy"})}), "[[pass(Table:fixture), argument], [fail(x:bad), fail(x:boy)]]");
    }

    @Test
    public void oneRowThatExplicitlyFails() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"fail:bad", "fail:boy"})}), "[[pass(Table:fixture), argument], [fail(bad), fail(boy)]]");
    }

    @Test
    public void oneRowThatExplicitlyFailsNoChange() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"fail", "fail"})}), "[[pass(Table:fixture), argument], [fail(2), fail(4)]]");
    }

    @Test
    public void oneRowThatExplicitlyIgnoresNoChange() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"ignore", "ignore"})}), "[[pass(Table:fixture), argument], [ignore(2), ignore(4)]]");
    }

    @Test
    public void oneRowThatExplicitlyIgnoresWithChange() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"ignore:x", "ignore:y"})}), "[[pass(Table:fixture), argument], [ignore(x), ignore(y)]]");
    }

    @Test
    public void oneRowThatReports() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"report:x", "report:y"})}), "[[pass(Table:fixture), argument], [x, y]]");
    }

    @Test
    public void noChange() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"no change", "no change"})}), "[[pass(Table:fixture), argument], [2, 4]]");
    }

    @Test
    public void blankNoChange() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", ""})}), "[[pass(Table:fixture), argument], [2, 4]]");
    }

    @Test
    public void error() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"error:myError", "error:anError"})}), "[[pass(Table:fixture), argument], [error(myError), error(anError)]]");
    }

    @Test
    public void surplusErrors() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", "", "error:surplus A"}), ListUtility.list((String[])new String[]{"error:surplus B", "error:surplus C"})}), "[[pass(Table:fixture), argument], [2, 4, error(surplus A)], [error(surplus B), error(surplus C)]]");
    }

    @Test
    public void surplusFailures() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", "", "fail:surplus A"}), ListUtility.list((String[])new String[]{"fail:surplus B", "fail:surplus C"})}), "[[pass(Table:fixture), argument], [2, 4, fail(surplus A)], [fail(surplus B), fail(surplus C)]]");
    }

    @Test
    public void surplusImplicitFailures() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", "", "fail"}), ListUtility.list((String[])new String[]{"fail", "fail"})}), "[[pass(Table:fixture), argument], [2, 4, fail(fail)], [fail(fail), fail(fail)]]");
    }

    @Test
    public void surplusImplicitPasses() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", "", "pass"}), ListUtility.list((String[])new String[]{"pass", "pass"})}), "[[pass(Table:fixture), argument], [2, 4, pass(pass)], [pass(pass), pass(pass)]]");
    }

    @Test
    public void surplusExplicitPasses() throws Exception {
        this.assertTableResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", "", "pass:x"}), ListUtility.list((String[])new String[]{"pass:y", "pass:z"})}), "[[pass(Table:fixture), argument], [2, 4, pass(x)], [pass(y), pass(z)]]");
    }

    @Test
    public void emptyTableWithResults() throws Exception {
        this.assertTableResults("", ListUtility.list((Object[])new Object[]{ListUtility.list((String[])new String[]{"", "pass:x"}), ListUtility.list((String[])new String[]{"pass:y", "pass:z"})}), "[[pass(Table:fixture), argument], [, pass(x)], [pass(y), pass(z)]]");
    }

    @Test
    public void tableWithSymbols() throws Exception {
        this.makeTableTableAndBuildInstructions("|Table:fixture|argument|\n|$X|$X|\n");
        this.tt.setSymbol("X", "value");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"tableTable_id_0", "OK"}), ListUtility.list((Object[])new Object[]{"tableTable_id_1", ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"pass", "fail"})})})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)"[[pass(Table:fixture), argument], [pass($X->[value]), fail($X->[value])]]", (Object)this.tt.getTable().toString());
    }

    @Test
    public void tableMethodReturnsNull() throws Exception {
        this.assertTableResults("|2|4|\n", null, "[[pass(Table:fixture), ignore(No results from table)], [2, 4]]");
    }

    @Test
    public void tableMethodThrowsException() throws Exception {
        this.makeTableTableAndBuildInstructions("|Table:fixture|argument|\n|2|4|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"tableTable_id_0", "OK"}), ListUtility.list((String[])new String[]{"tableTable_id_1", "Exception: except"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)"[[error(Exception: except), argument], [2, 4]]", (Object)this.tt.getTable().toString());
    }
}

