/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.FileUpdate;
import fitnesse.updates.Update;
import fitnesse.updates.UpdateTestCase;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class FileUpdateTest
extends UpdateTestCase {
    public final File testFile = new File("classes/testFile");

    protected Update makeUpdate() throws Exception {
        return new FileUpdate(this.context.getRootPagePath(), "testFile", "files" + File.separator + "images");
    }

    public void setUp() throws Exception {
        super.setUp();
        this.testFile.createNewFile();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.testFile.delete();
    }

    @Test
    public void testSimpleFunctions() throws Exception {
        Assert.assertTrue((String)"doesn't want to apply", (boolean)this.update.shouldBeApplied());
        Assert.assertTrue((String)"wrong message", (boolean)this.update.getMessage().equals("."));
        Assert.assertEquals((Object)"FileUpdate(testFile)", (Object)this.update.getName());
    }

    @Test
    public void testUpdateWithMissingDirectories() throws Exception {
        this.update.doUpdate();
        File file = new File(this.context.getRootPagePath() + File.separator + "files" + File.separator + "images" + File.separator + "testFile");
        Assert.assertTrue((boolean)file.exists());
        Assert.assertFalse((boolean)this.update.shouldBeApplied());
    }

    @Test(expected=Exception.class)
    public void testFileMissing() throws Exception {
        this.update = new FileUpdate(this.updater.context.getRootPagePath(), "images/missingFile", "files/images");
        this.update.doUpdate();
    }
}

