/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import util.Clock;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileSystemPageTest {
    private static final String defaultPath = "./teststorage";
    private static final File base = new File("./teststorage");
    private FileSystemPage root;
    private PageCrawler crawler;
    private static final List<String> cmMethodCalls = new ArrayList();

    @BeforeClass
    public static void initialize() {
        FileUtil.deleteFileSystemDirectory((File)base);
        FileUtil.deleteFileSystemDirectory((String)"RooT");
    }

    @Before
    public void setUp() throws Exception {
        cmMethodCalls.clear();
        FileUtil.deleteFileSystemDirectory((File)base);
        FileSystemPageTest.createFileSystemDirectory((File)base);
        this.root = new FileSystemPage("./teststorage", "RooT");
        this.crawler = this.root.getPageCrawler();
    }

    @After
    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((File)base);
        FileUtil.deleteFileSystemDirectory((String)"RooT");
    }

    public static void createFileSystemDirectory(File current) {
        current.mkdir();
    }

    @Test
    public void testCreateBase() throws Exception {
        FileSystemPage levelA = (FileSystemPage)this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageA"), "");
        Assert.assertEquals((Object)"./teststorage/RooT/PageA", (Object)levelA.getFileSystemPath());
        Assert.assertTrue((boolean)new File("./teststorage/RooT/PageA").exists());
    }

    @Test
    public void testTwoLevel() throws Exception {
        WikiPage levelA = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageA"));
        this.crawler.addPage(levelA, PathParser.parse((String)"PageB"));
        Assert.assertTrue((boolean)new File("./teststorage/RooT/PageA/PageB").exists());
    }

    @Test
    public void testContent() throws Exception {
        WikiPagePath rootPath = PathParser.parse((String)"root");
        Assert.assertEquals((Object)"", (Object)this.crawler.getPage((WikiPage)this.root, rootPath).getData().getContent());
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"AaAa"), "A content");
        Assert.assertEquals((Object)"A content", (Object)this.root.getChildPage("AaAa").getData().getContent());
        WikiPagePath bPath = PathParser.parse((String)"AaAa.BbBb");
        this.crawler.addPage((WikiPage)this.root, bPath, "B content");
        Assert.assertEquals((Object)"B content", (Object)this.crawler.getPage((WikiPage)this.root, bPath).getData().getContent());
    }

    @Test
    public void testBigContent() throws Exception {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            buffer.append("abcdefghijklmnopqrstuvwxyz");
        }
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"BigPage"), buffer.toString());
        String content = this.root.getChildPage("BigPage").getData().getContent();
        Assert.assertTrue((boolean)buffer.toString().equals(content));
    }

    @Test
    public void testPageExists() throws Exception {
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"AaAa"), "A content");
        Assert.assertTrue((boolean)this.root.hasChildPage("AaAa"));
    }

    @Test
    public void testGetChidren() throws Exception {
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"AaAa"), "A content");
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"BbBb"), "B content");
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"CcCc"), "C content");
        new File("./teststorage/root/someOtherDir").mkdir();
        List children = this.root.getChildren();
        Assert.assertEquals((long)3L, (long)children.size());
        for (WikiPage child : children) {
            String name = child.getName();
            boolean isOk = "AaAa".equals(name) || "BbBb".equals(name) || "CcCc".equals(name);
            Assert.assertTrue((String)("WikiPAge is not a valid one: " + name), (boolean)isOk);
        }
    }

    @Test
    public void testRemovePage() throws Exception {
        WikiPage levelOne = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"LevelOne"));
        this.crawler.addPage(levelOne, PathParser.parse((String)"LevelTwo"));
        levelOne.removeChildPage("LevelTwo");
        File fileOne = new File("./teststorage/RooT/LevelOne");
        File fileTwo = new File("./teststorage/RooT/LevelOne/LevelTwo");
        Assert.assertTrue((boolean)fileOne.exists());
        Assert.assertFalse((boolean)fileTwo.exists());
    }

    @Test
    public void testDelTree() throws Exception {
        WikiPage levelOne = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"LevelOne"));
        this.crawler.addPage(levelOne, PathParser.parse((String)"LevelTwo"));
        File childOne = new File("./teststorage/RooT/LevelOne");
        File childTwo = new File("./teststorage/RooT/LevelOne/LevelTwo");
        Assert.assertTrue((boolean)childOne.exists());
        this.root.removeChildPage("LevelOne");
        Assert.assertFalse((boolean)childTwo.exists());
        Assert.assertFalse((boolean)childOne.exists());
    }

    @Test
    public void testDefaultAttributes() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne"), "something");
        Assert.assertTrue((boolean)page.getData().hasAttribute("Edit"));
        Assert.assertTrue((boolean)page.getData().hasAttribute("Search"));
        Assert.assertFalse((boolean)page.getData().hasAttribute("Test"));
        Assert.assertFalse((boolean)page.getData().hasAttribute("TestSuite"));
    }

    @Test
    public void testPersistentAttributes() throws Exception {
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"FrontPage"));
        WikiPage createdPage = this.root.getChildPage("FrontPage");
        PageData data = createdPage.getData();
        data.setAttribute("Test", "true");
        data.setAttribute("Search", "true");
        createdPage.commit(data);
        Assert.assertTrue((boolean)data.hasAttribute("Test"));
        Assert.assertTrue((boolean)data.hasAttribute("Search"));
        WikiPage page = this.root.getChildPage("FrontPage");
        Assert.assertTrue((boolean)page.getData().hasAttribute("Test"));
        Assert.assertTrue((boolean)page.getData().hasAttribute("Search"));
    }

    @Test
    public void testCachedInfo() throws Exception {
        WikiPage page1 = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"PageOne"), "page one");
        WikiPage child1 = this.crawler.addPage(page1, PathParser.parse((String)"ChildOne"), "child one");
        WikiPage child = page1.getChildPage("ChildOne");
        Assert.assertSame((Object)child1, (Object)child);
    }

    @Test
    public void testCanFindExistingPages() throws Exception {
        this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"FrontPage"), "front page");
        FileSystemPage newRoot = new FileSystemPage("./teststorage", "RooT");
        Assert.assertNotNull((Object)newRoot.getChildPage("FrontPage"));
    }

    @Test
    public void testGetPath() throws Exception {
        Assert.assertEquals((Object)"./teststorage/RooT", (Object)this.root.getFileSystemPath());
    }

    @Test
    public void testLastModifiedTime() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"SomePage"), "some text");
        page.commit(page.getData());
        long now = Clock.currentTimeInMillis();
        Date lastModified = page.getData().getProperties().getLastModificationTime();
        Assert.assertTrue((now - lastModified.getTime() <= 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testUnicodeCharacters() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"SomePage"), "\uba80\uba81\uba82\uba83");
        PageData data = page.getData();
        Assert.assertEquals((Object)"\uba80\uba81\uba82\uba83", (Object)data.getContent());
    }

    @Test
    public void testLoadChildrenWhenPageIsDeletedManualy() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"));
        page.getChildren();
        FileUtil.deleteFileSystemDirectory((String)((FileSystemPage)page).getFileSystemPath());
        try {
            page.getChildren();
        }
        catch (Exception e) {
            Assert.fail((String)"No Exception should be thrown");
        }
    }

    public static void cmUpdate(String file, String payload) {
        cmMethodCalls.add(String.format("update %s|%s", file, payload));
    }

    public static void cmEdit(String file, String payload) {
        cmMethodCalls.add(String.format("edit %s|%s", file, payload));
    }

    public static void cmDelete(String file, String payload) {
        cmMethodCalls.add(String.format("delete %s|%s", file, payload));
    }

    public static void cmPreDelete(String file, String payload) {
        cmMethodCalls.add(String.format("preDelete %s|%s", file, payload));
    }

    @Test
    public void cmPluginNotCalledIfBlank() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"), "!define CM_SYSTEM {}");
        cmMethodCalls.clear();
        page.addChildPage("CreatedPage");
        Assert.assertEquals((long)0L, (long)cmMethodCalls.size());
    }

    @Test
    public void cmPluginCalledForCreate() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"), "!define CM_SYSTEM {fitnesse.wiki.FileSystemPageTest xxx}");
        cmMethodCalls.clear();
        page.addChildPage("CreatedPage");
        Assert.assertEquals((long)1L, (long)cmMethodCalls.size());
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/CreatedPage|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(0));
    }

    @Test
    public void cmPluginCalledIfNoPayload() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"), "!define CM_SYSTEM {fitnesse.wiki.FileSystemPageTest}");
        cmMethodCalls.clear();
        page.addChildPage("CreatedPage");
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/CreatedPage|fitnesse.wiki.FileSystemPageTest", cmMethodCalls.get(0));
        Assert.assertEquals((long)1L, (long)cmMethodCalls.size());
    }

    @Test
    public void cmPluginEditAndUpdateCalledForReWrite() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"), "!define CM_SYSTEM {fitnesse.wiki.FileSystemPageTest xxx}");
        cmMethodCalls.clear();
        page.commit(page.getData());
        Assert.assertEquals((long)4L, (long)cmMethodCalls.size());
        Assert.assertEquals((Object)"edit ./teststorage/RooT/TestPage/content.txt|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(0));
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/content.txt|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(1));
        Assert.assertEquals((Object)"edit ./teststorage/RooT/TestPage/properties.xml|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(2));
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/properties.xml|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(3));
    }

    @Test
    public void cmPluginEditNotCalledIfNewPage() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"), "!define CM_SYSTEM {fitnesse.wiki.FileSystemPageTest xxx}");
        cmMethodCalls.clear();
        this.crawler.addPage(page, PathParser.parse((String)"NewPage"), "raw content");
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/NewPage|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(0));
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/NewPage/content.txt|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(1));
        Assert.assertEquals((Object)"update ./teststorage/RooT/TestPage/NewPage/properties.xml|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(2));
        Assert.assertEquals((long)3L, (long)cmMethodCalls.size());
    }

    @Test
    public void cmPluginCalledForDelete() throws Exception {
        WikiPage page = this.crawler.addPage((WikiPage)this.root, PathParser.parse((String)"TestPage"), "!define CM_SYSTEM {fitnesse.wiki.FileSystemPageTest xxx}");
        page.addChildPage("CreatedPage");
        cmMethodCalls.clear();
        page.removeChildPage("CreatedPage");
        Assert.assertEquals((long)2L, (long)cmMethodCalls.size());
        Assert.assertEquals((Object)"preDelete ./teststorage/RooT/TestPage/CreatedPage|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(0));
        Assert.assertEquals((Object)"delete ./teststorage/RooT/TestPage/CreatedPage|fitnesse.wiki.FileSystemPageTest xxx", cmMethodCalls.get(1));
    }
}

