/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.ComponentFactory;
import fitnesse.WikiPageFactory;
import fitnesse.wiki.ExternalSuitePage;
import fitnesse.wiki.ExternalTestPage;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.PageRepository;
import fitnesse.wiki.WikiPage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileSystem;
import util.MemoryFileSystem;

public class PageRepositoryTest {
    private FileSystem fileSystem;
    private PageRepository pageRepository;
    private FileSystemPage rootPage;

    @Before
    public void SetUp() throws Exception {
        this.fileSystem = new MemoryFileSystem();
        this.pageRepository = new PageRepository(this.fileSystem);
        this.rootPage = (FileSystemPage)new WikiPageFactory(this.fileSystem).makeRootPage(".", "somepath", new ComponentFactory());
    }

    @Test
    public void DirectoryOfHtmlFilesIsExternalSuitePage() throws Exception {
        this.fileSystem.makeFile("./somepath/ExternalSuite/myfile.html", "stuff");
        WikiPage page = this.pageRepository.makeChildPage("ExternalSuite", this.rootPage);
        Assert.assertEquals(ExternalSuitePage.class, page.getClass());
    }

    @Test
    public void DirectoryOfDirectoryOfHtmlFilesIsExternalSuitePage() throws Exception {
        this.fileSystem.makeFile("./somepath/ExternalSuite/subsuite/myfile.html", "stuff");
        WikiPage page = this.pageRepository.makeChildPage("ExternalSuite", this.rootPage);
        Assert.assertEquals(ExternalSuitePage.class, page.getClass());
    }

    @Test
    public void DirectoryWithoutHtmlFilesIsFileSystemPage() throws Exception {
        this.fileSystem.makeFile("./somepath/WikiPage/myfile.txt", "stuff");
        this.fileSystem.makeFile("./somepath/OtherPage/myfile.html", "stuff");
        WikiPage page = this.pageRepository.makeChildPage("WikiPage", this.rootPage);
        Assert.assertEquals(FileSystemPage.class, page.getClass());
    }

    @Test
    public void DirectoryWithContentIsFileSystemPage() throws Exception {
        this.fileSystem.makeFile("./somepath/WikiPage/content.txt", "stuff");
        this.fileSystem.makeFile("./somepath/WikiPage/subsuite/myfile.html", "stuff");
        WikiPage page = this.pageRepository.makeChildPage("WikiPage", this.rootPage);
        Assert.assertEquals(FileSystemPage.class, page.getClass());
    }

    @Test
    public void HtmlFileIsExternalSuitePageChild() throws Exception {
        this.fileSystem.makeFile("./somepath/ExternalSuite/myfile.html", "stuff");
        ExternalSuitePage page = (ExternalSuitePage)this.pageRepository.makeChildPage("ExternalSuite", this.rootPage);
        WikiPage child = (WikiPage)this.pageRepository.findChildren(page).get(0);
        Assert.assertEquals(ExternalTestPage.class, child.getClass());
        Assert.assertEquals((Object)"MyfilE", (Object)child.getName());
    }

    @Test
    public void DirectoryOfHtmlFilesIsExternalSuitePageChild() throws Exception {
        this.fileSystem.makeFile("./somepath/ExternalSuite/subsuite/myfile.html", "stuff");
        ExternalSuitePage page = (ExternalSuitePage)this.pageRepository.makeChildPage("ExternalSuite", this.rootPage);
        WikiPage child = (WikiPage)this.pageRepository.findChildren(page).get(0);
        Assert.assertEquals(ExternalSuitePage.class, child.getClass());
        Assert.assertEquals((Object)"SubsuitE", (Object)child.getName());
    }
}

