/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.WikiPagePath;
import fitnesse.wikitext.parser.WikiWordPath;
import java.util.Iterator;

/*
 * Exception performing whole class analysis ignored.
 */
public class PathParser {
    public static final String PATH_SEPARATOR = ".";
    public static final String PATH_PREFIX_CHARS = ".<>^";
    private WikiPagePath path;

    public static WikiPagePath parse(String pathName) {
        return new PathParser().makePath(pathName);
    }

    private WikiPagePath makePath(String pathName) {
        this.path = new WikiPagePath();
        if (pathName.equals("")) {
            return this.path;
        }
        if (pathName.equals("root") || pathName.equals(".") || pathName.equals("/")) {
            this.path.makeAbsolute();
            return this.path;
        }
        return this.parsePathName(pathName);
    }

    private WikiPagePath parsePathName(String pathName) {
        if (pathName.startsWith(".")) {
            this.path.makeAbsolute();
            pathName = pathName.substring(1);
        } else if (pathName.startsWith(">") || pathName.startsWith("^")) {
            this.path.setPathMode(WikiPagePath.Mode.SUB_PAGE);
            pathName = pathName.substring(1);
        } else if (pathName.startsWith("<")) {
            this.path.setPathMode(WikiPagePath.Mode.BACKWARD_SEARCH);
            pathName = pathName.substring(1);
        }
        String[] names = pathName.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            String pageName = names[i];
            if (!PathParser.nameIsValid((String)pageName)) {
                return null;
            }
            this.path.addNameToEnd(pageName);
        }
        return this.path;
    }

    public static boolean isPathPrefix(Character c) {
        return ".<>^".indexOf(c.charValue()) >= 0;
    }

    private static boolean nameIsValid(String name) {
        return WikiWordPath.isWikiWord((String)name);
    }

    public static String render(WikiPagePath path) {
        StringBuffer renderedPath = new StringBuffer();
        if (path.isSubPagePath()) {
            renderedPath.append(">");
        } else if (path.isBackwardSearchPath()) {
            renderedPath.append("<");
        } else if (path.isAbsolute()) {
            renderedPath.append(".");
        }
        Iterator i = path.getNames().iterator();
        if (i.hasNext()) {
            String name = (String)i.next();
            renderedPath.append(name);
        }
        while (i.hasNext()) {
            renderedPath.append(".").append(i.next());
        }
        return renderedPath.toString();
    }
}

