/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.LinkedList;
import java.util.List;

public class SymbolicPage
extends BaseWikiPage {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "SymbolicLinks";
    private WikiPage realPage;

    public SymbolicPage(String name, WikiPage realPage, WikiPage parent) {
        super(name, parent);
        this.realPage = realPage;
    }

    public WikiPage getRealPage() {
        return this.realPage;
    }

    public WikiPage addChildPage(String name) {
        return this.realPage.addChildPage(name);
    }

    public boolean hasChildPage(String name) {
        return this.realPage.hasChildPage(name);
    }

    protected WikiPage getNormalChildPage(String name) {
        WikiPage childPage = this.realPage.getChildPage(name);
        if (childPage != null && !(childPage instanceof SymbolicPage)) {
            childPage = new SymbolicPage(name, childPage, (WikiPage)this);
        }
        return childPage;
    }

    protected WikiPage createInternalSymbolicPage(String linkPath, String linkName) {
        WikiPagePath path = PathParser.parse((String)linkPath);
        WikiPage start = path.isRelativePath() ? this.getRealPage().getParent() : this.getRealPage();
        WikiPage page = this.getPageCrawler().getPage(start, path);
        if (page != null) {
            page = new SymbolicPage(linkName, page, (WikiPage)this);
        }
        return page;
    }

    public void removeChildPage(String name) {
        this.realPage.removeChildPage(name);
    }

    public List<WikiPage> getNormalChildren() {
        List children = this.realPage.getChildren();
        LinkedList<WikiPage> symChildren = new LinkedList<WikiPage>();
        for (WikiPage child : children) {
            symChildren.add((WikiPage)new SymbolicPage(child.getName(), child, (WikiPage)this));
        }
        return symChildren;
    }

    public PageData getData() {
        PageData data = this.realPage.getData();
        data.setWikiPage((WikiPage)this);
        return data;
    }

    public ReadOnlyPageData readOnlyData() {
        return this.getData();
    }

    public PageData getDataVersion(String versionName) {
        PageData data = this.realPage.getDataVersion(versionName);
        data.setWikiPage((WikiPage)this);
        return data;
    }

    public VersionInfo commit(PageData data) {
        return this.realPage.commit(data);
    }
}

