/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.PageFactory;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.templateUtilities.HtmlPage;
import fitnesse.testutil.FitNesseUtil;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageActions;
import fitnesse.wiki.WikiPageProperty;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.Clock;
import util.RegexTestCase;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiImportPropertyTest
extends RegexTestCase {
    private WikiImportProperty property;
    private WikiPage page;
    private WikiPage root;
    private PageCrawler crawler;

    public void setUp() {
        this.property = new WikiImportProperty("");
    }

    public void testSource() throws Exception {
        this.property = new WikiImportProperty("import source");
        WikiImportPropertyTest.assertEquals((String)"import source", (String)this.property.getSourceUrl());
        WikiImportPropertyTest.assertEquals((String)"import source", (String)this.property.get("Source"));
    }

    public void testIsRoot() throws Exception {
        WikiImportPropertyTest.assertFalse((boolean)this.property.isRoot());
        WikiImportPropertyTest.assertFalse((boolean)this.property.has("IsRoot"));
        this.property.setRoot(true);
        WikiImportPropertyTest.assertTrue((boolean)this.property.isRoot());
        WikiImportPropertyTest.assertTrue((boolean)this.property.has("IsRoot"));
    }

    public void testAutoUpdate() throws Exception {
        WikiImportPropertyTest.assertFalse((boolean)this.property.isAutoUpdate());
        WikiImportPropertyTest.assertFalse((boolean)this.property.has("AutoUpdate"));
        this.property.setAutoUpdate(true);
        WikiImportPropertyTest.assertTrue((boolean)this.property.isAutoUpdate());
        WikiImportPropertyTest.assertTrue((boolean)this.property.has("AutoUpdate"));
    }

    public void testLastUpdated() throws Exception {
        SimpleDateFormat format = WikiPageProperty.getTimeFormat();
        Date date = Clock.currentDate();
        this.property.setLastRemoteModificationTime(date);
        WikiImportPropertyTest.assertEquals((String)format.format(date), (String)format.format(this.property.getLastRemoteModificationTime()));
        WikiImportPropertyTest.assertEquals((String)format.format(date), (String)this.property.get("LastRemoteModification"));
    }

    public void testFailedCreateFromProperty() throws Exception {
        WikiImportPropertyTest.assertNull((Object)WikiImportProperty.createFrom((WikiPageProperty)new WikiPageProperty()));
    }

    public void testCreateFromProperty() throws Exception {
        WikiPageProperty rawImportProperty = this.property.set("WikiImport");
        rawImportProperty.set("IsRoot");
        rawImportProperty.set("AutoUpdate");
        rawImportProperty.set("Source", "some source");
        Date date = Clock.currentDate();
        rawImportProperty.set("LastRemoteModification", WikiPageProperty.getTimeFormat().format(date));
        WikiImportProperty importProperty = WikiImportProperty.createFrom((WikiPageProperty)this.property);
        WikiImportPropertyTest.assertEquals((String)"some source", (String)importProperty.getSourceUrl());
        WikiImportPropertyTest.assertTrue((boolean)importProperty.isRoot());
        WikiImportPropertyTest.assertTrue((boolean)importProperty.isAutoUpdate());
        SimpleDateFormat format = WikiPageProperty.getTimeFormat();
        WikiImportPropertyTest.assertEquals((String)format.format(date), (String)format.format(importProperty.getLastRemoteModificationTime()));
    }

    public void testAddtoProperty() throws Exception {
        WikiImportProperty importProperty = new WikiImportProperty("some source");
        importProperty.setRoot(true);
        importProperty.setAutoUpdate(true);
        importProperty.addTo((WikiPageProperty)this.property);
        WikiImportProperty importProperty2 = WikiImportProperty.createFrom((WikiPageProperty)this.property);
        WikiImportPropertyTest.assertEquals((String)"some source", (String)importProperty2.getSourceUrl());
        WikiImportPropertyTest.assertTrue((boolean)importProperty2.isRoot());
        WikiImportPropertyTest.assertTrue((boolean)importProperty2.isAutoUpdate());
    }

    public void pageRenderingSetUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.crawler = this.root.getPageCrawler();
    }

    private SimpleResponse requestPage(String name) throws Exception {
        MockRequest request = new MockRequest();
        request.setResource(name);
        WikiPageResponder responder = new WikiPageResponder();
        return (SimpleResponse)responder.makeResponse(FitNesseUtil.makeTestContext((WikiPage)this.root), (Request)request);
    }

    public void testImportedPageIndication() throws Exception {
        this.pageRenderingSetUp();
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SamplePage"));
        PageData data = this.page.getData();
        WikiImportProperty importProperty = new WikiImportProperty("blah");
        importProperty.addTo((WikiPageProperty)data.getProperties());
        this.page.commit(data);
        String content = this.getContentAfterSpecialImportHandling();
        WikiImportPropertyTest.assertSubString((String)"<body class=\"imported\">", (String)content);
    }

    public void testEditActions() throws Exception {
        this.pageRenderingSetUp();
        this.page = this.crawler.addPage(this.root, PathParser.parse((String)"SamplePage"));
        PageData data = this.page.getData();
        this.page.commit(data);
        String content = this.getContentAfterSpecialImportHandling();
        WikiImportPropertyTest.assertNotSubString((String)"Edit Locally", (String)content);
        WikiImportPropertyTest.assertNotSubString((String)"Edit Remotely", (String)content);
        WikiImportProperty importProperty = new WikiImportProperty("blah");
        importProperty.addTo((WikiPageProperty)data.getProperties());
        this.page.commit(data);
        content = this.getContentAfterSpecialImportHandling();
        WikiImportPropertyTest.assertTrue((boolean)WikiImportProperty.isImported((PageData)data));
        WikiImportPropertyTest.assertSubString((String)"<a href=\"SamplePage?edit\" accesskey=\"e\">Edit Locally</a>", (String)content);
        WikiImportPropertyTest.assertSubString((String)"<a href=\"blah?responder=edit&amp;redirectToReferer=true&amp;redirectAction=importAndView\">Edit Remotely</a>", (String)content);
    }

    private String getContentAfterSpecialImportHandling() throws Exception {
        HtmlPage html = new PageFactory(FitNesseUtil.makeTestContext()).newPage();
        WikiImportProperty.handleImportProperties((HtmlPage)html, (WikiPage)this.page);
        html.setNavTemplate("wikiNav.vm");
        html.put("actions", (Object)new WikiPageActions(this.page));
        return html.html();
    }
}

