/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.WikiPageProperty;
import fitnesse.wikitext.Utils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import util.Clock;
import util.XmlUtil;
import util.XmlWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class WikiPageProperties
extends WikiPageProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<?, ?> symbolicLinks;

    public WikiPageProperties() {
        this.symbolicLinks = new HashMap();
    }

    public WikiPageProperties(InputStream inputStream) {
        this();
        this.loadFromXmlStream(inputStream);
    }

    public WikiPageProperties(Element rootElement) {
        this();
        this.loadFromRootElement(rootElement);
    }

    public WikiPageProperties(WikiPageProperties that) {
        if (that != null && that.children != null) {
            this.children = new HashMap(that.children);
        }
        this.symbolicLinks = new HashMap(that.symbolicLinks);
    }

    public void loadFromXmlStream(InputStream inputStream) {
        Document document;
        try {
            document = XmlUtil.newDocument((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse XML from stream", e);
        }
        Element root = document.getDocumentElement();
        this.loadFromRootElement(root);
    }

    public void loadFromRootElement(Element root) {
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            String key = node.getNodeName();
            this.LoadElement((WikiPageProperty)this, (Element)node, key);
        }
    }

    private void LoadElement(WikiPageProperty context, Element element, String key) {
        WikiPageProperty newProperty = new WikiPageProperty();
        context.set(key, newProperty);
        NodeList nodes = element.getChildNodes();
        if (element.hasAttribute("value")) {
            newProperty.setValue(element.getAttribute("value"));
        } else if (nodes.getLength() == 1) {
            newProperty.setValue(nodes.item(0).getNodeValue());
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (!(childNode instanceof Element)) continue;
            this.LoadElement(newProperty, (Element)childNode, childNode.getNodeName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) throws Exception {
        Document document = null;
        XmlWriter writer = null;
        try {
            document = XmlUtil.newDocument();
            document.appendChild(this.makeRootElement(document));
            writer = new XmlWriter(outputStream);
            writer.write(document);
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    public Element makeRootElement(Document document) {
        Element root = document.createElement("properties");
        ArrayList keys = new ArrayList(this.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            WikiPageProperty childProperty = this.getProperty(key);
            this.toXml(childProperty, key, document, root);
        }
        return root;
    }

    private void toXml(WikiPageProperty context, String key, Document document, Element parent) {
        Element element = document.createElement(key);
        String value = context.getValue();
        if (context.hasChildren()) {
            if (value != null) {
                element.setAttribute("value", value);
            }
            Set childKeys = context.keySet();
            for (String childKey : childKeys) {
                WikiPageProperty child = context.getProperty(childKey);
                if (child == null) {
                    System.err.println("Property key \"" + childKey + "\" has null value for {" + context + "}");
                    continue;
                }
                this.toXml(child, childKey, document, element);
            }
        } else if (value != null) {
            element.appendChild(document.createTextNode(Utils.escapeHTML((String)value)));
        }
        parent.appendChild(element);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString("WikiPageProperties", 0));
        return s.toString();
    }

    public Date getLastModificationTime() {
        String dateStr = this.get("LastModified");
        if (dateStr == null) {
            return Clock.currentDate();
        }
        try {
            return WikiPageProperties.getTimeFormat().parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse date '" + dateStr + "'", e);
        }
    }

    public void setLastModificationTime(Date date) {
        this.set("LastModified", WikiPageProperties.getTimeFormat().format(date));
    }
}

