/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

public class Variable
extends SymbolType
implements Rule,
Translation {
    public static final Variable symbolType = new Variable();

    public Variable() {
        super("Variable");
        this.wikiMatcher(new Matcher().string("${"));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Maybe name = parser.parseToAsString(SymbolType.CloseBrace);
        if (name.isNothing() || ((String)name.getValue()).length() == 0) {
            return Symbol.nothing;
        }
        String variableName = (String)name.getValue();
        if (!ScanString.isVariableName((String)variableName)) {
            return Symbol.nothing;
        }
        current.add(variableName);
        Maybe variableValue = parser.getVariableSource().findVariable(variableName);
        if (variableValue.isNothing()) {
            current.add(new Symbol(SymbolType.Meta).add("undefined variable: " + variableName));
        } else {
            Symbol variableValueSymbol = parser.parseWithParent((String)variableValue.getValue(), null);
            current.add(variableValueSymbol);
        }
        return new Maybe((Object)current);
    }

    public String toTarget(Translator translator, Symbol symbol) {
        return translator.translate(symbol.childAt(1));
    }
}

