/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.parser.ParsedPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.test.TestSourcePage;
import org.junit.Assert;
import org.junit.Test;

public class ParsedPageTest {
    @Test
    public void parsesContent() {
        ParsedPage parsedPage = new ParsedPage((SourcePage)new TestSourcePage(), "''hi''");
        Assert.assertEquals((Object)"<i>hi</i>", (Object)parsedPage.toHtml());
    }

    @Test
    public void usesVariablesFromSourcePage() {
        ParsedPage sourcePage = new ParsedPage((SourcePage)new TestSourcePage(), "!define x {hi}");
        ParsedPage parsedPage = new ParsedPage(sourcePage, "${x}");
        Assert.assertEquals((Object)"hi", (Object)parsedPage.toHtml());
    }

    @Test
    public void addsPageToFront() {
        ParsedPage pageToAddFrom = new ParsedPage((SourcePage)new TestSourcePage(), "'''hi'''");
        ParsedPage pageToAddTo = new ParsedPage((SourcePage)new TestSourcePage(), "''mom''");
        pageToAddTo.addToFront(pageToAddFrom);
        Assert.assertEquals((Object)"<b>hi</b><i>mom</i>", (Object)pageToAddTo.toHtml());
    }
}

