/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class PlainTextTableTest {
    @Test
    public void scansPlainTextTables() {
        ParserTestHelper.assertScansTokenType((String)"![\nstuff\n]!", (String)"PlainTextTable", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"![\nstuff\n]!", (String)"ClosePlainTextTable", (boolean)true);
    }

    @Test
    public void parsesPlainTextTables() throws Exception {
        ParserTestHelper.assertParses((String)"![\nstuff\n]!", (String)"SymbolList[PlainTextTable[SymbolList[SymbolList[Text]]]]");
    }

    @Test
    public void translatesPlainTextTables() throws Exception {
        ParserTestHelper.assertTranslatesTo((String)"![\nstuff\n]!", (String)("<table class=\"plain_text_table\">" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td>stuff</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "</table>" + HtmlElement.endl));
    }

    @Test
    public void hidesFirstRow() throws Exception {
        ParserTestHelper.assertTranslatesTo((String)"![ stuff\n]!", (String)("<table class=\"plain_text_table\">" + HtmlElement.endl + "\t<tr class=\"hidden\">" + HtmlElement.endl + "\t\t<td>stuff</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "</table>" + HtmlElement.endl));
    }

    @Test
    public void translatesDelimitedColumns() throws Exception {
        ParserTestHelper.assertTranslatesTo((String)"![:\nstuff:nonsense\n]!", (String)("<table class=\"plain_text_table\">" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td>stuff</td>" + HtmlElement.endl + "\t\t<td>nonsense</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "</table>" + HtmlElement.endl));
    }
}

