/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Test;

public class TableTest {
    @Test
    public void scansTables() {
        ParserTestHelper.assertScansTokenType((String)"|a|\n", (String)"Table", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!|a|\n", (String)"Table", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"-|a|\n", (String)"Table", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"-!|a|\n", (String)"Table", (boolean)true);
    }

    @Test
    public void translatesTables() {
        ParserTestHelper.assertTranslatesTo((String)"|a|\n", (String)this.tableWithCell("a"));
        ParserTestHelper.assertTranslatesTo((String)"|a| \n", (String)this.tableWithCell("a"));
        ParserTestHelper.assertTranslatesTo((String)"|a|", (String)this.tableWithCell("a"));
        ParserTestHelper.assertTranslatesTo((String)"||\n", (String)this.tableWithCell(""));
        ParserTestHelper.assertTranslatesTo((String)"| a |\n", (String)this.tableWithCell("a"));
        ParserTestHelper.assertTranslatesTo((String)"|!- a -!|\n", (String)this.tableWithCell(" a "));
        ParserTestHelper.assertTranslatesTo((String)"|''a''|\n", (String)this.tableWithCell("<i>a</i>"));
        ParserTestHelper.assertTranslatesTo((String)"|!c a|\n", (String)this.tableWithCell("<center>a</center>"));
        ParserTestHelper.assertTranslatesTo((String)"|http://mysite.org|\n", (String)this.tableWithCell("<a href=\"http://mysite.org\">http://mysite.org</a>"));
        ParserTestHelper.assertTranslatesTo((String)"|!-line\nbreaks\n-!|\n", (String)this.tableWithCell("line\nbreaks\n"));
        ParserTestHelper.assertTranslatesTo((String)"|a|b|c|\n|d|e|f|\n", (String)("<table>" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td>a</td>" + HtmlElement.endl + "\t\t<td>b</td>" + HtmlElement.endl + "\t\t<td>c</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td>d</td>" + HtmlElement.endl + "\t\t<td>e</td>" + HtmlElement.endl + "\t\t<td>f</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "</table>" + HtmlElement.endl));
    }

    @Test
    public void ignoresMalformedTables() {
        ParserTestHelper.assertTranslatesTo((String)"!|\n\n|a|\n", (String)("!|<br/><br/>" + this.tableWithCell("a")));
    }

    @Test
    public void ignoreMostMarkupInLiteralTable() {
        ParserTestHelper.assertTranslatesTo((String)"!|''<a''|\n", (String)this.tableWithCell("''&lt;a''"));
        ParserTestHelper.assertTranslatesTo((String)"!|a@b.com|\n", (String)this.tableWithCell("a@b.com"));
    }

    @Test
    public void evaluatesExpressionsInLiteralTable() {
        ParserTestHelper.assertTranslatesTo((String)"!|${=3+4=}|\n", (String)this.tableWithCell("7"));
    }

    @Test
    public void normalizesRowLength() {
        ParserTestHelper.assertTranslatesTo((String)"|a|\n|b|c|\n|d|e|f|\n", (String)("<table>" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td colspan=\"3\">a</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td>b</td>" + HtmlElement.endl + "\t\t<td colspan=\"2\">c</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "\t<tr>" + HtmlElement.endl + "\t\t<td>d</td>" + HtmlElement.endl + "\t\t<td>e</td>" + HtmlElement.endl + "\t\t<td>f</td>" + HtmlElement.endl + "\t</tr>" + HtmlElement.endl + "</table>" + HtmlElement.endl));
    }

    @Test
    public void hidesFirstRowInCommentTable() {
        ParserTestHelper.assertTranslatesTo((String)"-|a|\n", (String)this.tableWithCellAndRow("a", "<tr class=\"hidden\">"));
    }

    @Test
    public void combinesLiteralAndCommentOptions() {
        ParserTestHelper.assertTranslatesTo((String)"-!|''<a''|\n", (String)this.tableWithCellAndRow("''&lt;a''", "<tr class=\"hidden\">"));
    }

    @Test
    public void overridesNestedRule() {
        ParserTestHelper.assertTranslatesTo((String)"|''|\n", (String)this.tableWithCell("''"));
        ParserTestHelper.assertTranslatesTo((String)"|''a|\n''", (String)(this.tableWithCell("''a") + "''"));
    }

    @Test
    public void translatesNestedLiteralTable() {
        ParserTestHelper.assertTranslatesTo((String)"|${x}|\n", (VariableSource)new TestVariableSource("x", "!|y|\n"), (String)this.tableWithCell(ParserTestHelper.nestedTableWithCellAndRow((String)"y", (String)"<tr>")));
    }

    @Test
    public void translatesLiteralNestedTable() {
        ParserTestHelper.assertTranslatesTo((String)"!|${x}|\n", (VariableSource)new TestVariableSource("x", "|y|\n"), (String)this.tableWithCell("|y|"));
    }

    @Test
    public void translatesVariableWithWhitespace() {
        ParserTestHelper.assertTranslatesTo((String)"!|${x}|\n", (VariableSource)new TestVariableSource("x", " a "), (String)this.tableWithCell("a"));
        ParserTestHelper.assertTranslatesTo((String)"!|${x}|\n", (VariableSource)new TestVariableSource("x", "!- a -!"), (String)this.tableWithCell(" a "));
        ParserTestHelper.assertTranslatesTo((String)"!|${x}|\n${x}", (VariableSource)new TestVariableSource("x", "!- a -!"), (String)(this.tableWithCell(" a ") + " a "));
    }

    private String tableWithCell(String cellContent) {
        return ParserTestHelper.tableWithCell((String)cellContent);
    }

    private String tableWithCellAndRow(String cellContent, String firstRow) {
        return ParserTestHelper.tableWithCellAndRow((String)cellContent, (String)firstRow);
    }
}

