/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.internal.runners.statements.FailOnTimeout;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailOnTimeout
extends Statement {
    private final Statement fOriginalStatement;
    private final TimeUnit fTimeUnit;
    private final long fTimeout;

    public FailOnTimeout(Statement originalStatement, long millis) {
        this(originalStatement, millis, TimeUnit.MILLISECONDS);
    }

    public FailOnTimeout(Statement originalStatement, long timeout, TimeUnit unit) {
        this.fOriginalStatement = originalStatement;
        this.fTimeout = timeout;
        this.fTimeUnit = unit;
    }

    public void evaluate() throws Throwable {
        FutureTask task = new FutureTask(new CallableStatement(this, null));
        Thread thread = new Thread(task, "Time-limited test");
        thread.setDaemon(true);
        thread.start();
        Throwable throwable = this.getResult(task, thread);
        if (throwable != null) {
            throw throwable;
        }
    }

    private Throwable getResult(FutureTask<Throwable> task, Thread thread) {
        try {
            return task.get(this.fTimeout, this.fTimeUnit);
        }
        catch (InterruptedException e) {
            return e;
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
        catch (TimeoutException e) {
            return this.createTimeoutException(thread);
        }
    }

    private Exception createTimeoutException(Thread thread) {
        StackTraceElement[] stackTrace = thread.getStackTrace();
        Exception exception = new Exception(String.format("test timed out after %d %s", this.fTimeout, this.fTimeUnit.name().toLowerCase()));
        if (stackTrace != null) {
            exception.setStackTrace(stackTrace);
            thread.interrupt();
        }
        return exception;
    }

    static /* synthetic */ Statement access$100(FailOnTimeout x0) {
        return x0.fOriginalStatement;
    }
}

