/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.junit.Assert;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.rules.ExpectedExceptionMatcherBuilder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectedException
implements TestRule {
    private final ExpectedExceptionMatcherBuilder fMatcherBuilder = new ExpectedExceptionMatcherBuilder();
    private boolean handleAssumptionViolatedExceptions = false;
    private boolean handleAssertionErrors = false;
    private String missingExceptionMessage;

    public static ExpectedException none() {
        return new ExpectedException();
    }

    private ExpectedException() {
    }

    public ExpectedException handleAssertionErrors() {
        this.handleAssertionErrors = true;
        return this;
    }

    public ExpectedException handleAssumptionViolatedExceptions() {
        this.handleAssumptionViolatedExceptions = true;
        return this;
    }

    public ExpectedException reportMissingExceptionWithMessage(String message) {
        this.missingExceptionMessage = message;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return new ExpectedExceptionStatement(this, base);
    }

    public void expect(Matcher<?> matcher) {
        this.fMatcherBuilder.add(matcher);
    }

    public void expect(Class<? extends Throwable> type) {
        this.expect(CoreMatchers.instanceOf(type));
    }

    public void expectMessage(String substring) {
        this.expectMessage(CoreMatchers.containsString((String)substring));
    }

    public void expectMessage(Matcher<String> matcher) {
        this.expect(ThrowableMessageMatcher.hasMessage(matcher));
    }

    public void expectCause(Matcher<? extends Throwable> expectedCause) {
        this.expect(ThrowableCauseMatcher.hasCause(expectedCause));
    }

    private void optionallyHandleException(Throwable e, boolean handleException) throws Throwable {
        if (!handleException) {
            throw e;
        }
        this.handleException(e);
    }

    private void handleException(Throwable e) throws Throwable {
        if (!this.fMatcherBuilder.expectsThrowable()) {
            throw e;
        }
        Assert.assertThat((Object)e, (Matcher)this.fMatcherBuilder.build());
    }

    private void failDueToMissingException() throws AssertionError {
        Assert.fail((String)this.missingExceptionMessage());
    }

    private String missingExceptionMessage() {
        if (this.isMissingExceptionMessageEmpty()) {
            String expectation = StringDescription.toString((SelfDescribing)this.fMatcherBuilder.build());
            return "Expected test to throw " + expectation;
        }
        return this.missingExceptionMessage;
    }

    private boolean isMissingExceptionMessageEmpty() {
        return this.missingExceptionMessage == null || this.missingExceptionMessage.length() == 0;
    }

    static /* synthetic */ boolean access$000(ExpectedException x0) {
        return x0.handleAssumptionViolatedExceptions;
    }

    static /* synthetic */ void access$100(ExpectedException x0, Throwable x1, boolean x2) throws Throwable {
        x0.optionallyHandleException(x1, x2);
    }

    static /* synthetic */ boolean access$200(ExpectedException x0) {
        return x0.handleAssertionErrors;
    }

    static /* synthetic */ void access$300(ExpectedException x0, Throwable x1) throws Throwable {
        x0.handleException(x1);
    }

    static /* synthetic */ ExpectedExceptionMatcherBuilder access$400(ExpectedException x0) {
        return x0.fMatcherBuilder;
    }

    static /* synthetic */ void access$500(ExpectedException x0) throws AssertionError {
        x0.failDueToMissingException();
    }
}

