/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.scijava.maven.plugin.enforcer.CollectionOutput;

public class CollectionOutputTest {
    private final DummyAppender appender = new DummyAppender();
    private static final DummyStringProvider STRING_PROVIDER = new DummyStringProvider();
    private static final String SEPARATOR = ", ";
    private StringBuilder output;

    @Before
    public void setUp() {
        this.output = new StringBuilder();
    }

    @Test
    public void joinCollection_WithStringProvider_WithEmptyCollection() throws Exception {
        MatcherAssert.assertThat((Object)CollectionOutput.joinCollection(Collections.emptyList(), (CollectionOutput.StringProvider)STRING_PROVIDER, (String)SEPARATOR), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void joinCollection_WithStringProvider_WithSingletonCollection() throws Exception {
        MatcherAssert.assertThat((Object)CollectionOutput.joinCollection(Collections.singletonList("entry1"), (CollectionOutput.StringProvider)STRING_PROVIDER, (String)SEPARATOR), (Matcher)Matchers.is((Object)"entry1"));
    }

    @Test
    public void joinCollection_WithStringProvider_WithCollectionHavingMultipleEntries() throws Exception {
        MatcherAssert.assertThat((Object)CollectionOutput.joinCollection(Arrays.asList("entry1", "entry2"), (CollectionOutput.StringProvider)STRING_PROVIDER, (String)SEPARATOR), (Matcher)Matchers.is((Object)"entry1, entry2"));
    }

    @Test
    public void joinArray_WithStringProvider_WithEmptyArray() throws Exception {
        MatcherAssert.assertThat((Object)CollectionOutput.joinArray((Object[])new String[0], (CollectionOutput.StringProvider)STRING_PROVIDER, (String)SEPARATOR), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void joinArray_WithStringProvider_WithSingletonArray() throws Exception {
        MatcherAssert.assertThat((Object)CollectionOutput.joinArray((Object[])new String[]{"entry1"}, (CollectionOutput.StringProvider)STRING_PROVIDER, (String)SEPARATOR), (Matcher)Matchers.is((Object)"entry1"));
    }

    @Test
    public void joinArray_WithStringProvider_WithArrayHavingMultipleEntries() throws Exception {
        MatcherAssert.assertThat((Object)CollectionOutput.joinArray((Object[])new String[]{"entry1", "entry2"}, (CollectionOutput.StringProvider)STRING_PROVIDER, (String)SEPARATOR), (Matcher)Matchers.is((Object)"entry1, entry2"));
    }

    @Test
    public void joinCollection_WithAppender_WithEmptyCollection() throws Exception {
        CollectionOutput.joinCollection(Collections.emptyList(), (StringBuilder)this.output, (CollectionOutput.Appender)this.appender, (String)SEPARATOR);
        MatcherAssert.assertThat((Object)this.output.toString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void joinCollection_WithAppender_WithSingletonCollection() throws Exception {
        CollectionOutput.joinCollection(Collections.singletonList("entry1"), (StringBuilder)this.output, (CollectionOutput.Appender)this.appender, (String)SEPARATOR);
        MatcherAssert.assertThat((Object)this.output.toString(), (Matcher)Matchers.is((Object)"entry1"));
    }

    @Test
    public void joinCollection_WithAppender_WithCollectionHavingMultipleEntries() throws Exception {
        CollectionOutput.joinCollection(Arrays.asList("entry1", "entry2"), (StringBuilder)this.output, (CollectionOutput.Appender)this.appender, (String)SEPARATOR);
        MatcherAssert.assertThat((Object)this.output.toString(), (Matcher)Matchers.is((Object)"entry1, entry2"));
    }

    @Test
    public void joinCollection_WithAppender_WithNewlineSeparator() throws Exception {
        CollectionOutput.joinCollection(Arrays.asList("entry1", "entry2"), (StringBuilder)this.output, (CollectionOutput.Appender)this.appender, (String)"\n");
        MatcherAssert.assertThat((Object)this.output.toString(), (Matcher)Matchers.is((Object)"entry1\nentry2"));
    }

    private static class DummyStringProvider
    implements CollectionOutput.StringProvider<String> {
        private DummyStringProvider() {
        }

        public String provide(String value) {
            return value;
        }
    }

    private class DummyAppender
    implements CollectionOutput.Appender<String> {
        private DummyAppender() {
        }

        public void append(String value) {
            CollectionOutputTest.this.output.append(value);
        }
    }
}

