/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import util.StreamReader;

public class StreamReader {
    private InputStream input;
    private State state;
    ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    OutputStream output;
    private int readGoal;
    private int readStatus;
    private boolean eof = false;
    private byte[] boundary;
    private int boundaryLength;
    private int matchingBoundaryIndex;
    private byte[] matchedBoundaryBytes;
    private long bytesConsumed;
    private final State READLINE_STATE = new /* Unavailable Anonymous Inner Class!! */;
    private final State READCOUNT_STATE = new /* Unavailable Anonymous Inner Class!! */;
    private final State READUPTO_STATE = new /* Unavailable Anonymous Inner Class!! */;
    private final State FINAL_STATE = new /* Unavailable Anonymous Inner Class!! */;

    public StreamReader(InputStream input) {
        this.input = input;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public String readLine() throws IOException {
        return this.bytesToString(this.readLineBytes());
    }

    public byte[] readLineBytes() throws IOException {
        this.state = this.READLINE_STATE;
        return this.preformRead();
    }

    public String read(int count) throws IOException {
        return this.bytesToString(this.readBytes(count));
    }

    public byte[] readBytes(int count) throws IOException {
        this.readGoal = count;
        this.readStatus = 0;
        this.state = this.READCOUNT_STATE;
        return this.preformRead();
    }

    public void copyBytes(int count, OutputStream output) throws IOException {
        this.readGoal = count;
        this.state = this.READCOUNT_STATE;
        this.performCopy(output);
    }

    public String readUpTo(String boundary) throws IOException {
        return this.bytesToString(this.readBytesUpTo(boundary));
    }

    public byte[] readBytesUpTo(String boundary) throws IOException {
        this.prepareForReadUpTo(boundary);
        return this.preformRead();
    }

    private void prepareForReadUpTo(String boundary) {
        this.boundary = boundary.getBytes();
        this.boundaryLength = this.boundary.length;
        this.matchedBoundaryBytes = new byte[this.boundaryLength];
        this.matchingBoundaryIndex = 0;
        this.state = this.READUPTO_STATE;
    }

    public void copyBytesUpTo(String boundary, OutputStream outputStream) throws IOException {
        this.prepareForReadUpTo(boundary);
        this.performCopy(outputStream);
    }

    public int byteCount() {
        return this.byteBuffer.size();
    }

    public byte[] getBufferedBytes() {
        return this.byteBuffer.toByteArray();
    }

    private byte[] preformRead() throws IOException {
        this.setReadMode();
        this.clearBuffer();
        this.readUntilFinished();
        return this.getBufferedBytes();
    }

    private void performCopy(OutputStream output) throws IOException {
        this.setCopyMode(output);
        this.readUntilFinished();
    }

    private void readUntilFinished() throws IOException {
        while (!this.state.finished()) {
            this.state.read(this.input);
        }
    }

    private void clearBuffer() {
        this.byteBuffer.reset();
    }

    private void setCopyMode(OutputStream output) {
        this.output = output;
    }

    private void setReadMode() {
        this.output = this.byteBuffer;
    }

    private String bytesToString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, "UTF-8");
    }

    private void changeState(State state) {
        this.state = state;
    }

    public boolean isEof() {
        return this.eof;
    }

    public long numberOfBytesConsumed() {
        return this.bytesConsumed;
    }

    public void resetNumberOfBytesConsumed() {
        this.bytesConsumed = 0L;
    }

    static /* synthetic */ State access$100(StreamReader x0) {
        return x0.FINAL_STATE;
    }

    static /* synthetic */ void access$200(StreamReader x0, State x1) {
        x0.changeState(x1);
    }

    static /* synthetic */ boolean access$302(StreamReader x0, boolean x1) {
        x0.eof = x1;
        return x0.eof;
    }

    static /* synthetic */ long access$408(StreamReader x0) {
        return x0.bytesConsumed++;
    }

    static /* synthetic */ int access$500(StreamReader x0) {
        return x0.readGoal;
    }

    static /* synthetic */ int access$600(StreamReader x0) {
        return x0.readStatus;
    }

    static /* synthetic */ long access$414(StreamReader x0, long x1) {
        return x0.bytesConsumed += x1;
    }

    static /* synthetic */ int access$612(StreamReader x0, int x1) {
        return x0.readStatus += x1;
    }

    static /* synthetic */ byte[] access$700(StreamReader x0) {
        return x0.boundary;
    }

    static /* synthetic */ int access$800(StreamReader x0) {
        return x0.matchingBoundaryIndex;
    }

    static /* synthetic */ byte[] access$900(StreamReader x0) {
        return x0.matchedBoundaryBytes;
    }

    static /* synthetic */ int access$808(StreamReader x0) {
        return x0.matchingBoundaryIndex++;
    }

    static /* synthetic */ int access$1000(StreamReader x0) {
        return x0.boundaryLength;
    }

    static /* synthetic */ int access$802(StreamReader x0, int x1) {
        x0.matchingBoundaryIndex = x1;
        return x0.matchingBoundaryIndex;
    }
}

