/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import util.RegexTestCase;
import util.StreamReader;
import util.StreamReaderTest;

/*
 * Exception performing whole class analysis ignored.
 */
public class StreamReaderTest
extends RegexTestCase {
    private PipedOutputStream output;
    private StreamReader reader;
    private String readResult;
    private byte[] byteResult;
    private Thread thread;
    private Exception exception;

    public void setUp() throws Exception {
        this.output = new PipedOutputStream();
        this.reader = new StreamReader((InputStream)new PipedInputStream(this.output));
    }

    public void tearDown() throws Exception {
        this.output.close();
        this.reader.close();
    }

    private void writeToPipe(String value) throws Exception {
        byte[] bytes = value.getBytes();
        this.output.write(bytes);
    }

    public void testReadLine() throws Exception {
        this.startReading((ReadThread)new ReadLine(this));
        this.writeToPipe("a line\r\n");
        this.finishReading();
        StreamReaderTest.assertEquals((String)"a line", (String)this.readResult);
    }

    public void testReadLineBytes() throws Exception {
        this.startReading((ReadThread)new ReadLineBytes(this));
        this.writeToPipe("a line\r\n");
        this.finishReading();
        StreamReaderTest.assertEquals((String)"a line", (String)new String(this.byteResult));
    }

    public void testBufferCanGrow() throws Exception {
        this.startReading((ReadThread)new ReadLine(this));
        for (int i = 0; i < 1001; ++i) {
            this.writeToPipe(i + ",");
        }
        this.writeToPipe("\r\n");
        this.finishReading();
        StreamReaderTest.assertHasRegexp((String)"1000", (String)this.readResult);
    }

    public void testReadNumberOfBytesAsString() throws Exception {
        this.startReading((ReadThread)new ReadCount(this, 100));
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            buffer.append("*");
            this.writeToPipe("*");
        }
        this.finishReading();
        StreamReaderTest.assertEquals((String)buffer.toString(), (String)this.readResult);
    }

    public void testReadNumberOfBytes() throws Exception {
        this.startReading((ReadThread)new ReadCountBytes(this, 100));
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            buffer.append("*");
            this.writeToPipe("*");
        }
        this.finishReading();
        StreamReaderTest.assertEquals((String)buffer.toString(), (String)new String(this.byteResult));
    }

    public void testReadNumberOfBytesWithClosedInput() throws Exception {
        this.startReading((ReadThread)new ReadCountBytes(this, 100));
        for (int i = 0; i < 50; ++i) {
            this.writeToPipe("*");
        }
        this.output.close();
        this.finishReading();
        StreamReaderTest.assertEquals((String)"bytes consumed", (long)50L, (long)this.reader.numberOfBytesConsumed());
        StreamReaderTest.assertEquals((String)"bytes returned", (int)50, (int)this.byteResult.length);
    }

    public void testReadingZeroBytes() throws Exception {
        this.startReading((ReadThread)new ReadCount(this, 0));
        this.finishReading();
        StreamReaderTest.assertEquals((String)"", (String)this.readResult);
    }

    public void testReadUpTo() throws Exception {
        this.checkReadUoTo("--boundary", "some bytes--boundary", "some bytes");
    }

    public void testReadUpToNonEnd() throws Exception {
        this.checkReadUoTo("--bound", "some bytes--boundary", "some bytes");
    }

    public void testReadBytesUpTo() throws Exception {
        this.startReading((ReadThread)new ReadUpToBytes(this, "--boundary"));
        this.writeToPipe("some bytes--boundary");
        this.finishReading();
        StreamReaderTest.assertEquals((String)"some bytes", (String)new String(this.byteResult));
    }

    public void testReadUpTo2() throws Exception {
        this.checkReadUoTo("--bob", "----bob\r\n", "--");
    }

    public void testReadUpTo3() throws Exception {
        this.checkReadUoTo("12345", "112123123412345", "1121231234");
    }

    private void checkReadUoTo(String boundary, String input, String expected) throws Exception {
        this.startReading((ReadThread)new ReadUpTo(this, boundary));
        this.writeToPipe(input);
        this.finishReading();
        StreamReaderTest.assertEquals((String)expected, (String)this.readResult);
    }

    public void testCopyBytesUpTo() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.writeToPipe("some bytes--boundary");
        this.reader.copyBytesUpTo("--boundary", (OutputStream)outputStream);
        StreamReaderTest.assertEquals((String)"some bytes", (String)outputStream.toString());
    }

    public void testEofReadCount() throws Exception {
        this.writeToPipe("abcdefghijklmnopqrstuvwxyz");
        this.output.close();
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.read(10);
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.read(16);
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.read(1);
        StreamReaderTest.assertTrue((boolean)this.reader.isEof());
    }

    public void testEofReadLine() throws Exception {
        this.writeToPipe("one line\ntwo lines\nthree lines");
        this.output.close();
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.readLine();
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.readLine();
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.readLine();
        StreamReaderTest.assertTrue((boolean)this.reader.isEof());
    }

    public void testEofReadUpTo() throws Exception {
        this.writeToPipe("mark one, mark two, the end");
        this.output.close();
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.readUpTo("one");
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.readUpTo("two");
        StreamReaderTest.assertFalse((boolean)this.reader.isEof());
        this.reader.readUpTo("three");
        StreamReaderTest.assertTrue((boolean)this.reader.isEof());
    }

    public void testBytesConsumed() throws Exception {
        this.writeToPipe("One line\r\n12345abc-boundary");
        StreamReaderTest.assertEquals((long)0L, (long)this.reader.numberOfBytesConsumed());
        this.reader.readLine();
        StreamReaderTest.assertEquals((long)10L, (long)this.reader.numberOfBytesConsumed());
        this.reader.read(5);
        StreamReaderTest.assertEquals((long)15L, (long)this.reader.numberOfBytesConsumed());
        this.reader.readUpTo("-boundary");
        StreamReaderTest.assertEquals((long)27L, (long)this.reader.numberOfBytesConsumed());
    }

    public void testEarlyClosingStream() throws Exception {
        this.startReading((ReadThread)new ReadCount(this, 10));
        this.output.close();
        this.finishReading();
        StreamReaderTest.assertEquals((String)"", (String)this.readResult);
    }

    private void startReading(ReadThread thread) {
        this.thread = thread;
        this.thread.start();
    }

    private void finishReading() throws Exception {
        this.thread.join();
    }

    static /* synthetic */ Exception access$002(StreamReaderTest x0, Exception x1) {
        x0.exception = x1;
        return x0.exception;
    }

    static /* synthetic */ String access$102(StreamReaderTest x0, String x1) {
        x0.readResult = x1;
        return x0.readResult;
    }

    static /* synthetic */ StreamReader access$200(StreamReaderTest x0) {
        return x0.reader;
    }

    static /* synthetic */ byte[] access$302(StreamReaderTest x0, byte[] x1) {
        x0.byteResult = x1;
        return x1;
    }
}

