/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.install;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.scijava.maven.plugin.install.SubdirectoryPattern;

public final class KnownPlatforms {
    public static final List<String> FAMILIES = Arrays.asList("android", "ios", "linux", "macos", "macosx", "osx", "windows");
    public static final List<String> ARCHES = Arrays.asList("aarch64", "all", "amd64", "arm", "arm64", "armhf", "i586", "ppc64le", "universal", "x86", "x86_64");

    public static String shortName(String family, String arch) {
        if (KnownPlatforms.isMacOS(family)) {
            return "macosx";
        }
        if (KnownPlatforms.isWindows(family) && KnownPlatforms.isArch32(arch)) {
            return "win32";
        }
        if (KnownPlatforms.isWindows(family) && KnownPlatforms.isArch64(arch)) {
            return "win64";
        }
        if (KnownPlatforms.isLinux(family) && KnownPlatforms.isArch32(arch)) {
            return "linux32";
        }
        if (KnownPlatforms.isLinux(family) && KnownPlatforms.isArch64(arch)) {
            return "linux64";
        }
        return null;
    }

    public static List<String> nativeClassifiers() {
        ArrayList<String> classifiers = new ArrayList<String>();
        for (String family : FAMILIES) {
            for (String arch : ARCHES) {
                classifiers.add(family + "-" + arch);
                classifiers.add("native-" + family + "-" + arch);
                classifiers.add("natives-" + family + "-" + arch);
            }
            classifiers.add(family);
            classifiers.add("native-" + family);
            classifiers.add("natives-" + family);
        }
        return classifiers;
    }

    public static List<SubdirectoryPattern> nativeSubdirectoryPatterns() {
        HashMap<String, List<String>> patterns = new HashMap<String, List<String>>();
        for (String family : FAMILIES) {
            for (String arch : ARCHES) {
                String shortName = KnownPlatforms.shortName(family, arch);
                if (shortName == null) continue;
                KnownPlatforms.addClassifier(patterns, "jars/" + shortName, family + "-" + arch);
            }
            String shortName = KnownPlatforms.shortName(family, null);
            if (shortName == null) continue;
            KnownPlatforms.addClassifier(patterns, "jars/" + shortName, family);
        }
        return patterns.entrySet().stream().map(entry -> KnownPlatforms.pattern((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private static boolean isWindows(String family) {
        return "windows".equals(family);
    }

    private static boolean isLinux(String family) {
        return "linux".equals(family);
    }

    private static boolean isMacOS(String family) {
        String[] macFamily = new String[]{"macos", "macosx", "osx"};
        return Arrays.asList(macFamily).contains(family);
    }

    private static boolean isArch32(String arch) {
        return "i586".equals(arch) || "x86".equals(arch);
    }

    private static boolean isArch64(String arch) {
        return arch == null || "amd64".equals(arch) || "x86_64".equals(arch);
    }

    private static void addClassifier(Map<String, List<String>> patterns, String subdirectory, String classifier) {
        String[] prefixes = new String[]{"", "native-", "natives-"};
        List classifiers = patterns.computeIfAbsent(subdirectory, l -> new ArrayList());
        for (String prefix : prefixes) {
            classifiers.add("*:*:*:" + prefix + classifier);
        }
    }

    private static SubdirectoryPattern pattern(String subdirectory, List<String> patterns) {
        SubdirectoryPattern pattern = new SubdirectoryPattern();
        pattern.subdirectory = subdirectory;
        pattern.patterns = patterns;
        return pattern;
    }
}

