/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.api;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.SortedSet;
import org.scijava.discovery.Discoverer;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.InfoTree;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpHistory;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.api.OpRequest;
import org.scijava.ops.api.PartialOpRequest;
import org.scijava.priority.Prioritized;
import org.scijava.types.Nil;

public interface OpEnvironment
extends Prioritized<OpEnvironment> {
    public static OpEnvironment buildEmpty() {
        Optional opsOptional = Discoverer.using(ServiceLoader::load).discoverMax(OpEnvironment.class);
        return (OpEnvironment)opsOptional.orElseThrow(() -> new RuntimeException("No OpEnvironment Provided!"));
    }

    public static OpEnvironment build() {
        OpEnvironment ops = OpEnvironment.buildEmpty();
        ops.discoverEverything();
        return ops;
    }

    default public SortedSet<OpInfo> infos() {
        return this.infos(null, this.getDefaultHints());
    }

    public SortedSet<OpInfo> infos(String var1);

    public SortedSet<OpInfo> infos(Hints var1);

    public SortedSet<OpInfo> infos(String var1, Hints var2);

    public void discoverUsing(Discoverer ... var1);

    public void discoverEverything();

    public OpHistory history();

    default public <T> T op(String opName, Nil<T> specialType, Nil<?>[] inTypes, Nil<?> outType) {
        return this.op(opName, specialType, inTypes, outType, this.getDefaultHints());
    }

    public <T> T op(String var1, Nil<T> var2, Nil<?>[] var3, Nil<?> var4, Hints var5);

    default public <T> T opFromInfoTree(InfoTree tree, Nil<T> specialType) {
        return this.opFromInfoTree(tree, specialType, this.getDefaultHints());
    }

    public <T> T opFromInfoTree(InfoTree var1, Nil<T> var2, Hints var3);

    default public <T> T opFromSignature(String signature, Nil<T> specialType) {
        InfoTree info = this.treeFromSignature(signature);
        return this.opFromInfoTree(info, specialType);
    }

    public InfoTree treeFromSignature(String var1);

    default public OpBuilder op(String opName) {
        return new OpBuilder(this, opName);
    }

    default public OpBuilder op(String opName, Hints hints) {
        return new OpBuilder(this, opName, hints);
    }

    public Type genericType(Object var1);

    public <T> T typeLambda(Nil<T> var1, T var2);

    default public OpInfo opify(Class<?> opClass, String ... names) {
        return this.opify(opClass, 0.0, names);
    }

    public OpInfo opify(Class<?> var1, double var2, String ... var4);

    public void register(Object ... var1);

    public void setDefaultHints(Hints var1);

    public Hints getDefaultHints();

    default public String help() {
        return this.help(new PartialOpRequest());
    }

    default public String help(String name) {
        return this.help(new PartialOpRequest(name));
    }

    public String help(OpRequest var1);

    default public String helpVerbose() {
        return this.helpVerbose(new PartialOpRequest());
    }

    default public String helpVerbose(String name) {
        return this.helpVerbose(new PartialOpRequest(name));
    }

    public String helpVerbose(OpRequest var1);
}

