/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Types;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.matcher.impl.DefaultOpClassInfo;
import org.scijava.ops.engine.matcher.impl.DefaultOpFieldInfo;
import org.scijava.ops.engine.matcher.impl.DefaultOpMethodInfo;
import org.scijava.ops.engine.matcher.reduce.ReducedOpInfo;

public class OpDescriptionTest
extends AbstractTestEnvironment {
    public final BiFunction<Double, Double, Double> fieldOp = Double::sum;

    @Test
    public void testOpClassDescription() {
        DefaultOpClassInfo info = new DefaultOpClassInfo(ClassOp.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"test.classDescription"});
        String expected = "org.scijava.ops.engine.matcher.impl.OpDescriptionTest$ClassOp\n\t> input1 : java.lang.Double\n\t> input2 : java.lang.Double\n\tReturns : java.lang.Double";
        String actual = info.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static Double methodOp(Double in1, Double in2) {
        return in1 + in2;
    }

    @Test
    public void testOpMethodDescription() throws NoSuchMethodException {
        Method method = OpDescriptionTest.class.getMethod("methodOp", Double.class, Double.class);
        DefaultOpMethodInfo info = new DefaultOpMethodInfo(method, BiFunction.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"test.methodDescription"});
        String expected = "org.scijava.ops.engine.matcher.impl.OpDescriptionTest.methodOp(java.lang.Double,java.lang.Double)\n\t> input1 : java.lang.Double\n\t> input2 : java.lang.Double\n\tReturns : java.lang.Double";
        String actual = info.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testOpFieldDescription() throws NoSuchFieldException {
        Field field = OpDescriptionTest.class.getDeclaredField("fieldOp");
        DefaultOpFieldInfo info = new DefaultOpFieldInfo((Object)this, field, "", "", new Hints(new String[0]), 1.0, new String[]{"test.fieldDescription"});
        String expected = "org.scijava.ops.engine.matcher.impl.OpDescriptionTest$fieldOp\n\t> input1 : java.lang.Double\n\t> input2 : java.lang.Double\n\tReturns : java.lang.Double";
        String actual = info.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testReducedDescription() {
        DefaultOpClassInfo info = new DefaultOpClassInfo(ClassOp.class, "1.0", "", new Hints(new String[0]), 1.0, new String[]{"test.reductionDescription"});
        ParameterizedType opType = Types.parameterize(Function.class, (Type[])new Type[]{Double.class, Double.class});
        ReducedOpInfo reduced = new ReducedOpInfo((OpInfo)info, (Type)opType, 1);
        String expected = "org.scijava.ops.engine.matcher.impl.OpDescriptionTest$ClassOpReduction1\n\t> input1 : java.lang.Double\n\tReturns : java.lang.Double";
        String actual = reduced.toString();
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    static class ClassOp
    implements BiFunction<Double, Double, Double> {
        ClassOp() {
        }

        @Override
        public Double apply(Double t, Double u) {
            return t + u;
        }
    }
}

