/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.TestOps;
import org.scijava.ops.engine.util.Maps;
import org.scijava.types.Nil;

public class LiftTest
extends AbstractTestEnvironment {
    Nil<Double> nilDouble = new Nil<Double>(){};
    Nil<double[]> nilDoubleArray = new Nil<double[]>(){};

    @BeforeAll
    public static void AddNeededOps() {
        Object[] objects = LiftTest.objsFromNoArgConstructors(TestOps.class.getDeclaredClasses());
        ops.register(objects);
    }

    @Test
    public void testliftFunction() {
        Function powFunction = OpBuilder.matchFunction((OpEnvironment)ops, (String)"test.liftFunction", this.nilDouble, this.nilDouble);
        Function liftedToIterable = Maps.FunctionMaps.Iterables.liftBoth((Function)powFunction);
        Iterable res2 = (Iterable)liftedToIterable.apply(Arrays.asList(1.0, 2.0, 3.0, 4.0));
        Assertions.assertTrue((boolean)LiftTest.arrayEquals(LiftTest.toArray(res2), 2.0, 3.0, 4.0, 5.0));
        Function liftedToArray = Maps.FunctionMaps.Arrays.liftBoth((Function)powFunction, Double.class);
        Double[] res3 = (Double[])liftedToArray.apply(new Double[]{1.0, 2.0, 3.0, 4.0});
        Assertions.assertTrue((boolean)LiftTest.arrayEquals(Arrays.stream(res3).mapToDouble(d -> d).toArray(), 2.0, 3.0, 4.0, 5.0));
    }

    private static double[] toArray(Iterable<Double> iter) {
        return Streams.stream(iter).mapToDouble(d -> d).toArray();
    }

    @Test
    public void testliftComputer() {
        Computers.Arity1 powComputer = OpBuilder.matchComputer((OpEnvironment)ops, (String)"test.liftComputer", this.nilDoubleArray, this.nilDoubleArray);
        Computers.Arity1 liftedToIterable = Maps.ComputerMaps.Iterables.liftBoth((Computers.Arity1)powComputer);
        Iterable<double[]> res = LiftTest.wrap(new double[4]);
        liftedToIterable.compute(LiftTest.wrap(1.0, 2.0, 3.0, 4.0), res);
        Assertions.assertTrue((boolean)LiftTest.arrayEquals(LiftTest.unwrap(res), 2.0, 3.0, 4.0, 5.0));
    }

    private static double[] unwrap(Iterable<double[]> ds) {
        ArrayList<Double> wraps = new ArrayList<Double>();
        for (double[] d2 : ds) {
            wraps.add(d2[0]);
        }
        return wraps.stream().mapToDouble(d -> d).toArray();
    }

    private static Iterable<double[]> wrap(double ... ds) {
        ArrayList<double[]> wraps = new ArrayList<double[]>();
        for (double d : ds) {
            wraps.add(new double[]{d});
        }
        return wraps;
    }
}

