/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.util.FuncClass;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.types.Nil;

public class OpsAsParametersTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.parameter.computer")
    public final Function<Number, Double> func = x -> x.doubleValue();
    @OpField(names="test.parameter.op")
    public final BiFunction<List<Number>, Function<Number, Double>, List<Double>> biFunc = (x, op) -> {
        ArrayList<Double> output = new ArrayList<Double>();
        for (Number n : x) {
            output.add((Double)op.apply(n));
        }
        return output;
    };

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new OpsAsParametersTest()});
        ops.register(new Object[]{new FuncClass()});
    }

    @Test
    public void testOpWithNonReifiableFunction() {
        List<Number> list = Arrays.asList(40L, 20.5, 4.0);
        List actual = (List)ops.op("test.parameter.op").input(list, this.func).outType(List.class).apply();
        Assertions.assertEquals(Arrays.asList(40.0, 20.5, 4.0), (Object)actual);
    }

    @Test
    public void testOpWithOpFieldWithoutRun() {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(40L);
        list.add(20.5);
        list.add(4.0);
        BiFunction thing = OpBuilder.matchFunction((OpEnvironment)ops, (String)"test.parameter.op", (Nil)new Nil<List<Number>>(){}, (Nil)new Nil<Function<Number, Double>>(){}, (Nil)new Nil<List<Double>>(){});
        List output = (List)thing.apply(list, this.func);
    }

    @Test
    public void testOpWithOpClass() {
        ArrayList<Number> list = new ArrayList<Number>();
        list.add(40L);
        list.add(20.5);
        list.add(4.0);
        Function funcClass = OpBuilder.matchFunction((OpEnvironment)ops, (String)"test.parameter.class", (Nil)new Nil<Number>(){}, (Nil)new Nil<Double>(){});
        List output = (List)ops.op("test.parameter.op").input(list, (Object)funcClass).outType((Nil)new Nil<List<Double>>(){}).apply();
    }
}

