/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.scijava.common3.Annotations;
import org.scijava.meta.Versions;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.OpInfoGenerator;
import org.scijava.ops.engine.matcher.impl.DefaultOpFieldInfo;
import org.scijava.ops.engine.matcher.impl.DefaultOpMethodInfo;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;
import org.scijava.ops.spi.OpHints;
import org.scijava.ops.spi.OpMethod;

public class OpCollectionInfoGenerator
implements OpInfoGenerator {
    private Hints formHints(OpHints h) {
        if (h == null) {
            return new Hints(new String[0]);
        }
        return new Hints(h.hints());
    }

    protected List<OpInfo> processClass(Class<?> cls) {
        String version = Versions.of(cls);
        ArrayList<OpInfo> collectionInfos = new ArrayList<OpInfo>();
        List fields = Annotations.annotatedFields(cls, OpField.class);
        Optional<Object> instance = this.getInstance(cls);
        if (instance.isPresent()) {
            List fieldInfos = fields.parallelStream().map(f -> this.generateFieldInfo((Field)f, instance.get(), version)).collect(Collectors.toList());
            collectionInfos.addAll(fieldInfos);
        }
        List methodInfos = Annotations.annotatedMethods(cls, OpMethod.class).parallelStream().map(m -> this.generateMethodInfo((Method)m, version)).collect(Collectors.toList());
        collectionInfos.addAll(methodInfos);
        return collectionInfos;
    }

    private Optional<Object> getInstance(Class<?> c) {
        try {
            return Optional.of(c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception exc) {
            return Optional.empty();
        }
    }

    private DefaultOpFieldInfo generateFieldInfo(Field field, Object instance, String version) {
        boolean isStatic = Modifier.isStatic(field.getModifiers());
        OpField annotation = field.getAnnotation(OpField.class);
        return new DefaultOpFieldInfo(isStatic ? null : instance, field, version, annotation.description(), this.formHints(field.getAnnotation(OpHints.class)), annotation.priority(), Infos.parseNames(annotation.names()));
    }

    private DefaultOpMethodInfo generateMethodInfo(Method method, String version) {
        OpMethod annotation = method.getAnnotation(OpMethod.class);
        return new DefaultOpMethodInfo(method, annotation.type(), version, annotation.description(), this.formHints(method.getAnnotation(OpHints.class)), annotation.priority(), Infos.parseNames(annotation.names()));
    }

    @Override
    public boolean canGenerateFrom(Object o) {
        return o instanceof OpCollection;
    }

    @Override
    public List<OpInfo> generateInfosFrom(Object o) {
        return this.processClass(o.getClass());
    }
}

