/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.yaml.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.scijava.ops.api.Hints;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.engine.util.Infos;
import org.scijava.ops.engine.yaml.impl.YAMLOpMethodInfo;
import org.scijava.struct.Struct;

public abstract class AbstractYAMLOpInfo
implements OpInfo {
    protected final Map<String, Object> yaml;
    protected final String identifier;
    protected final List<String> names;
    protected final String description;
    protected final String version;
    protected final Double priority;
    protected final Hints hints;

    public AbstractYAMLOpInfo(Map<String, Object> yaml, String identifier) {
        this.yaml = yaml;
        this.identifier = identifier;
        this.names = this.parseNames();
        this.priority = this.parsePriority();
        this.description = yaml.getOrDefault("description", "").toString();
        this.version = (String)yaml.get("version");
        this.hints = new Hints(new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<String> parseNames() {
        List<String> names = new ArrayList<String>();
        if (this.yaml.containsKey("name")) {
            names.add((String)this.yaml.get("name"));
        } else {
            if (!this.yaml.containsKey("names")) throw new IllegalArgumentException("Op " + this.identifier + " declares no names!");
            Object tmp = this.yaml.get("names");
            if (tmp instanceof List) {
                names = (List)tmp;
            } else {
                if (!(tmp instanceof String)) throw new IllegalArgumentException("Cannot convert" + tmp + "to a String[]!");
                names.add((String)tmp);
            }
        }
        for (int i = 0; i < names.size(); ++i) {
            names.set(i, names.get(i).trim());
        }
        return names;
    }

    protected double parsePriority() {
        if (this.yaml.containsKey("priority")) {
            Object p = this.yaml.get("priority");
            if (p instanceof Number) {
                return ((Number)p).doubleValue();
            }
            if (p instanceof String) {
                return Double.parseDouble((String)p);
            }
            throw new IllegalArgumentException("Op priority " + p + " not parsable");
        }
        return 0.0;
    }

    public List<String> names() {
        return this.names;
    }

    public String description() {
        return this.description;
    }

    public Hints declaredHints() {
        return this.hints;
    }

    public double priority() {
        return this.priority;
    }

    public String version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (!(o instanceof YAMLOpMethodInfo)) {
            return false;
        }
        OpInfo that = (OpInfo)o;
        return this.struct().equals(that.struct());
    }

    public abstract Struct struct();

    public int hashCode() {
        return this.struct().hashCode();
    }

    public String toString() {
        return Infos.describe(this);
    }
}

