/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image;

import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import java.util.Arrays;
import java.util.Random;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss.Gauss;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.image.AbstractOpTest;

public abstract class AbstractColocalisationTest
extends AbstractOpTest {
    private static Img<UnsignedByteType> zeroCorrelationImageCh1;
    private static Img<UnsignedByteType> zeroCorrelationImageCh2;
    private static Img<UnsignedByteType> positiveCorrelationImageCh1;
    private static Img<UnsignedByteType> positiveCorrelationImageCh2;

    protected static OpBuilder op(String name) {
        return ops.op(name);
    }

    protected static Img<UnsignedByteType> getZeroCorrelationImageCh1() {
        if (zeroCorrelationImageCh1 == null) {
            zeroCorrelationImageCh1 = AbstractColocalisationTest.loadTiffFromJar("greenZstack.tif");
        }
        return zeroCorrelationImageCh1;
    }

    protected static Img<UnsignedByteType> getZeroCorrelationImageCh2() {
        if (zeroCorrelationImageCh2 == null) {
            zeroCorrelationImageCh2 = AbstractColocalisationTest.loadTiffFromJar("redZstack.tif");
        }
        return zeroCorrelationImageCh2;
    }

    protected static Img<UnsignedByteType> getPositiveCorrelationImageCh1() {
        if (positiveCorrelationImageCh1 == null) {
            positiveCorrelationImageCh1 = AbstractColocalisationTest.loadTiffFromJar("colocsample1b-green.tif");
        }
        return positiveCorrelationImageCh1;
    }

    protected static Img<UnsignedByteType> getPositiveCorrelationImageCh2() {
        if (positiveCorrelationImageCh2 == null) {
            positiveCorrelationImageCh2 = AbstractColocalisationTest.loadTiffFromJar("colocsample1b-red.tif");
        }
        return positiveCorrelationImageCh2;
    }

    private static <T extends RealType<T> & NativeType<T>> Img<T> loadTiffFromJar(String relPath) {
        ImgOpener opener = new ImgOpener();
        String source = "src/test/resources/org/scijava/ops/image/coloc/" + relPath;
        try {
            FileLocation location = new FileLocation(source);
            return (Img)opener.openImgs((Location)location).get(0);
        }
        catch (ImgIOException exc) {
            throw new IllegalStateException("File " + relPath + " is unexpectedly inaccessible?");
        }
    }

    public static <T extends RealType<T> & NativeType<T>> Img<T> produceMeanBasedNoiseImage(T type, int width, int height, double mean, double spread, double[] smoothingSigma, long seed) throws IllegalArgumentException {
        if (mean < spread || mean + spread > type.getMaxValue()) {
            throw new IllegalArgumentException("Mean must be larger than spread, and mean plus spread must be smaller than max of the type");
        }
        ArrayImgFactory imgFactory = new ArrayImgFactory(type);
        Img noiseImage = imgFactory.create(new long[]{width, height});
        Random r = new Random(seed);
        for (RealType value : Views.iterable((RandomAccessibleInterval)noiseImage)) {
            value.setReal(mean + (r.nextDouble() - 0.5) * spread);
        }
        return AbstractColocalisationTest.gaussianSmooth(noiseImage, smoothingSigma);
    }

    public static <T extends RealType<T> & NativeType<T>> Img<T> gaussianSmooth(RandomAccessibleInterval<T> img, double[] sigma) {
        IterableInterval interval = Views.iterable(img);
        ArrayImgFactory outputFactory = new ArrayImgFactory((NativeType)((RealType)Util.getTypeFromInterval(img)));
        long[] dim = new long[img.numDimensions()];
        img.dimensions(dim);
        Img output = outputFactory.create(dim);
        long[] pos = new long[img.numDimensions()];
        Arrays.fill(pos, 0L);
        Point origin = new Point(pos);
        ArrayImgFactory tempFactory = new ArrayImgFactory((NativeType)new FloatType());
        ExtendedRandomAccessibleInterval input = Views.extendMirrorSingle(img);
        Gauss.inFloat((double[])sigma, (RandomAccessible)input, (Interval)interval, (RandomAccessible)output, (Localizable)origin, (ImgFactory)tempFactory);
        return output;
    }
}

