/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.coloc;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.test.ImgLib2Assert;
import net.imglib2.type.numeric.RealType;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractColocalisationTest;
import org.scijava.ops.image.coloc.ShuffledView;

public class ShuffledViewTest
extends AbstractColocalisationTest {
    @Test
    public void testShuffleView() {
        ArrayImg actualInputImage = ArrayImgs.unsignedBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, (long[])new long[]{6L, 6L});
        int[] blockSize = new int[]{2, 2};
        long seed = -559038737L;
        ShuffledView shuffled = new ShuffledView((RandomAccessibleInterval)actualInputImage, blockSize, seed);
        ArrayImg expected = ArrayImgs.unsignedBytes((byte[])new byte[]{27, 28, 3, 4, 15, 16, 33, 34, 9, 10, 21, 22, 5, 6, 17, 18, 13, 14, 11, 12, 23, 24, 19, 20, 1, 2, 29, 30, 25, 26, 7, 8, 35, 36, 31, 32}, (long[])new long[]{6L, 6L});
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)expected, (RandomAccessibleInterval)shuffled);
    }

    @Test
    public void testSameSeed() {
        ArrayImg inputImage = ArrayImgs.unsignedBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, (long[])new long[]{6L, 6L});
        int[] blockSize = new int[]{2, 2};
        long seed = -559038737L;
        ShuffledView shuffled01 = new ShuffledView((RandomAccessibleInterval)inputImage, blockSize, seed);
        ShuffledView shuffled02 = new ShuffledView((RandomAccessibleInterval)inputImage, blockSize, seed);
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)shuffled01, (RandomAccessibleInterval)shuffled02);
    }

    @Test
    public <T extends RealType<T>, U extends RealType<U>> void testDiffSeeds() {
        ArrayImg inputImage = ArrayImgs.unsignedBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, (long[])new long[]{6L, 6L});
        int[] blockSize = new int[]{2, 2};
        long seed1 = -559038737L;
        long seed2 = 573785173L;
        ShuffledView shuffled1 = new ShuffledView((RandomAccessibleInterval)inputImage, blockSize, seed1);
        ArrayImg expected1 = ArrayImgs.unsignedBytes((byte[])new byte[]{27, 28, 3, 4, 15, 16, 33, 34, 9, 10, 21, 22, 5, 6, 17, 18, 13, 14, 11, 12, 23, 24, 19, 20, 1, 2, 29, 30, 25, 26, 7, 8, 35, 36, 31, 32}, (long[])new long[]{6L, 6L});
        ShuffledView shuffled2 = new ShuffledView((RandomAccessibleInterval)inputImage, blockSize, seed2);
        ArrayImg expected2 = ArrayImgs.unsignedBytes((byte[])new byte[]{29, 30, 25, 26, 17, 18, 35, 36, 31, 32, 23, 24, 5, 6, 27, 28, 15, 16, 11, 12, 33, 34, 21, 22, 3, 4, 13, 14, 1, 2, 9, 10, 19, 20, 7, 8}, (long[])new long[]{6L, 6L});
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)expected1, (RandomAccessibleInterval)shuffled1);
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)expected2, (RandomAccessibleInterval)shuffled2);
    }

    @Test
    public void testNonSquareBlocks1() {
        ArrayImg actualInputImage = ArrayImgs.unsignedBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, (long[])new long[]{6L, 6L});
        int[] blockSize = new int[]{2, 3};
        long seed = -559038737L;
        ShuffledView shuffled = new ShuffledView((RandomAccessibleInterval)actualInputImage, blockSize, seed);
        ArrayImg expected = ArrayImgs.unsignedBytes((byte[])new byte[]{21, 22, 5, 6, 1, 2, 27, 28, 11, 12, 7, 8, 33, 34, 17, 18, 13, 14, 23, 24, 3, 4, 19, 20, 29, 30, 9, 10, 25, 26, 35, 36, 15, 16, 31, 32}, (long[])new long[]{6L, 6L});
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)expected, (RandomAccessibleInterval)shuffled);
    }

    @Test
    public void testNonSquareBlocks2() {
        ArrayImg actualInputImage = ArrayImgs.unsignedBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, (long[])new long[]{6L, 6L});
        int[] blockSize = new int[]{3, 2};
        long seed = -559038737L;
        ShuffledView shuffled = new ShuffledView((RandomAccessibleInterval)actualInputImage, blockSize, seed);
        ArrayImg expected = ArrayImgs.unsignedBytes((byte[])new byte[]{25, 26, 27, 13, 14, 15, 31, 32, 33, 19, 20, 21, 1, 2, 3, 28, 29, 30, 7, 8, 9, 34, 35, 36, 4, 5, 6, 16, 17, 18, 10, 11, 12, 22, 23, 24}, (long[])new long[]{6L, 6L});
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)expected, (RandomAccessibleInterval)shuffled);
    }

    @Test
    public void testAllShuffle() {
        ArrayImg actualInputImage = ArrayImgs.unsignedBytes((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36}, (long[])new long[]{6L, 6L});
        int[] blockSize = new int[]{1, 1};
        long seed = -559038737L;
        ShuffledView shuffled = new ShuffledView((RandomAccessibleInterval)actualInputImage, blockSize, seed);
        ArrayImg expected = ArrayImgs.unsignedBytes((byte[])new byte[]{33, 19, 14, 36, 31, 32, 34, 21, 17, 30, 35, 1, 7, 28, 29, 20, 9, 12, 5, 18, 27, 3, 8, 2, 11, 25, 4, 24, 26, 6, 23, 10, 13, 15, 22, 16}, (long[])new long[]{6L, 6L});
        ImgLib2Assert.assertImageEquals((RandomAccessibleInterval)expected, (RandomAccessibleInterval)shuffled);
    }
}

